/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.caracal.entity;

import com.aqupd.caracal.entity.CaracalEntity;
import java.time.LocalDate;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class CaracalEntityModel
extends DefaultedEntityGeoModel<CaracalEntity> {
    public CaracalEntityModel() {
        super(new ResourceLocation("aqupdcaracal", "caracal"), true);
    }

    public ResourceLocation getModelResource(CaracalEntity entity) {
        return new ResourceLocation("aqupdcaracal", "geo/caracal.geo.json");
    }

    public ResourceLocation getTextureResource(CaracalEntity entity) {
        int day_of_month = LocalDate.now().getDayOfMonth();
        int month = LocalDate.now().getMonthValue();
        if (entity.m_7770_() != null && !entity.m_7770_().getString().isEmpty()) {
            String n = entity.m_7770_().getString().toLowerCase(Locale.ENGLISH);
            if (n.contains("\u0448\u043b\u044f\u043f") || n.contains("hat")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalshlopa.png");
            }
            if (n.contains("\u043c\u0438\u0440\u043d\u044b\u0439") || n.contains("peaceful")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalcommander.png");
            }
            if (n.contains("\u043a\u043e\u043c\u0430\u043d\u0434\u0438\u0440") || n.contains("commander")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalcommander.png");
            }
            if (n.contains("\u0430\u043d\u043e\u043d\u0438\u043c") || n.contains("anon")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalanonymous.png");
            }
            if (n.contains("\u043d\u043e\u0432\u043e\u0433\u043e\u0434\u043d\u0438\u0439") || n.contains("year")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalnewyear.png");
            }
            if (n.contains("\u0432\u0437\u0440\u044b\u0432\u043d\u043e\u0439") || n.contains("explosive")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalexplosive.png");
            }
            if (n.contains("\u0432\u043e\u0434\u043d\u044b\u0439") || n.contains("water")) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalwater.png");
            }
        } else {
            if (day_of_month >= 25 && month == 12 || day_of_month <= 5 && month == 1) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalchristmasdays.png");
            }
            if (day_of_month == 1 && month == 4) {
                return new ResourceLocation("aqupdcaracal", "textures/entity/caracalapril.png");
            }
            if (day_of_month == 6 && month == 5) {
                return switch (entity.getMaskColor()) {
                    case 1 -> new ResourceLocation("aqupdcaracal", "textures/entity/caracalbirthday1.png");
                    case 2 -> new ResourceLocation("aqupdcaracal", "textures/entity/caracalbirthday2.png");
                    case 3 -> new ResourceLocation("aqupdcaracal", "textures/entity/caracalbirthday3.png");
                    default -> new ResourceLocation("aqupdcaracal", "textures/entity/caracal.png");
                };
            }
        }
        return new ResourceLocation("aqupdcaracal", "textures/entity/caracal.png");
    }

    public ResourceLocation getAnimationResource(CaracalEntity animatable) {
        return new ResourceLocation("aqupdcaracal", "animations/caracal.animation.json");
    }
}

