/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.caracal.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class AqConfig {
    public static final AqConfig INSTANCE = new AqConfig();
    private boolean loaded;
    private final Properties aqprop = new Properties();
    private final File file = new File("./config/AqMods/caracal.config");

    private AqConfig() {
    }

    public boolean getBooleanProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Boolean.parseBoolean(this.aqprop.getProperty(key));
    }

    public String getStringProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return this.aqprop.getProperty(key);
    }

    public int getNumberProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Integer.parseInt(this.aqprop.getProperty(key));
    }

    public double getDoubleProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Double.parseDouble(this.aqprop.getProperty(key));
    }

    private void load() {
        this.loaded = true;
        try {
            Files.createDirectories(Paths.get("./config/AqMods/", new String[0]), new FileAttribute[0]);
            if (this.file.exists()) {
                FileReader reader = new FileReader(this.file);
                this.aqprop.load(reader);
                reader.close();
            } else {
                FileOutputStream writer = new FileOutputStream(this.file);
                this.file.createNewFile();
                this.aqprop.setProperty("config.version", "1");
                this.aqprop.setProperty("entity.health", "10.0");
                this.aqprop.setProperty("entity.speed", "0.3");
                this.aqprop.setProperty("entity.follow", "20.0");
                this.aqprop.setProperty("entity.damage", "2.5");
                this.aqprop.setProperty("entity.knockback", "0.5");
                this.aqprop.store(writer, "Configuration file for Caracal mod. spawn.biomes doesn't work for now");
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

