/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.data;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

public class HFMSavedData
extends SavedData {
    public static HashMap<String, Vector<Vec3i>> claimedChunks = new HashMap();

    public HFMSavedData() {
        claimedChunks = new HashMap();
    }

    public static HFMSavedData Create() {
        return new HFMSavedData();
    }

    public static HFMSavedData Load(CompoundTag tag) {
        HFMSavedData data = HFMSavedData.Create();
        ListTag playersChunks = tag.m_128437_("player_chunks", 10);
        if (playersChunks == null) {
            return data;
        }
        for (int i = 0; i < playersChunks.size(); ++i) {
            CompoundTag pc = (CompoundTag)playersChunks.get(i);
            String name = pc.m_128461_("name");
            int[] chunks_raw = pc.m_128465_("chunks_raw");
            Vector<Vec3i> chunks = new Vector<Vec3i>();
            for (int j = 0; j < chunks_raw.length; j += 2) {
                Vec3i pos = new Vec3i(chunks_raw[j], 0, chunks_raw[j + 1]);
                chunks.add(pos);
            }
            claimedChunks.put(name, chunks);
        }
        return data;
    }

    public static CompoundTag Save(CompoundTag tag) {
        ListTag playersChunks = new ListTag();
        List keys = claimedChunks.keySet().stream().toList();
        for (int i = 0; i < claimedChunks.size(); ++i) {
            CompoundTag playerTag = new CompoundTag();
            String name = (String)keys.get(i);
            playerTag.m_128359_("name", name);
            Vector<Vec3i> vecs = claimedChunks.get(name);
            int[] coords = new int[vecs.size() * 2];
            for (int j = 0; j < vecs.size(); ++j) {
                int n = j * 2;
                coords[n] = vecs.get(j).m_123341_();
                coords[n + 1] = vecs.get(j).m_123343_();
            }
            playerTag.m_128385_("chunks_raw", coords);
            playersChunks.add((Object)playerTag);
        }
        tag.m_128365_("player_chunks", (Tag)playersChunks);
        return tag;
    }

    public void read(CompoundTag nbt) {
        HFMSavedData.Load(nbt);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        return HFMSavedData.Save(nbt);
    }

    public String UpdateChunk(String name, Vec3i pos, boolean protect) {
        String owner = HFMSavedData.GetOwner(pos);
        if (owner != null && !owner.equals(name)) {
            return "Chunk already owned by " + owner;
        }
        Vector<Vec3i> list = claimedChunks.getOrDefault(name, new Vector());
        ChunkPos chunkCoord = new ChunkPos(new BlockPos(pos));
        Vec3i cleanChunkVec = new Vec3i(chunkCoord.f_45578_, 0, chunkCoord.f_45579_);
        String ret = "";
        if (!list.contains(cleanChunkVec) && protect) {
            list.add(cleanChunkVec);
            ret = "Chunk claimed";
        } else {
            list.remove(cleanChunkVec);
            ret = "Chunk unclaimed";
        }
        claimedChunks.put(name, list);
        this.m_77762_();
        return ret;
    }

    public String ClearAllPlayerChunks(String name) {
        if (claimedChunks.containsKey(name)) {
            claimedChunks.remove(name);
            this.m_77762_();
            return "Unclaimed all chunks owned by " + name;
        }
        return "Could not find any chunks owned by " + name;
    }

    public void ClearAllChunks() {
        claimedChunks = new HashMap();
        this.m_77762_();
    }

    public Vector<Vec3i> GetChunks(String name) {
        return claimedChunks.getOrDefault(name, new Vector());
    }

    public static String GetOwner(Vec3i blockPos) {
        ChunkPos chunkPos = new ChunkPos(new BlockPos(blockPos));
        Vec3i cleanChunkVec = new Vec3i(chunkPos.f_45578_, 0, chunkPos.f_45579_);
        List keys = claimedChunks.keySet().stream().toList();
        for (int i = 0; i < claimedChunks.size(); ++i) {
            String name = (String)keys.get(i);
            Vector vecs = claimedChunks.getOrDefault(name, new Vector());
            if (!vecs.contains(cleanChunkVec)) continue;
            return name;
        }
        return null;
    }
}

