/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.network.packets;

import com.dannyboythomas.hole_filler_mod.client.ClientConfig;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToolTipPacket {
    int max_hole_area;
    int max_diameter;
    int fill_speed;
    int undo_timer;

    public ToolTipPacket(FriendlyByteBuf buf) {
        this.max_hole_area = buf.readInt();
        this.max_diameter = buf.readInt();
        this.fill_speed = buf.readInt();
        this.undo_timer = buf.readInt();
    }

    public ToolTipPacket(int _max_area, int _max_diameter, int _fill_speed, int _undo_timer) {
        this.max_hole_area = _max_area;
        this.max_diameter = _max_diameter;
        this.fill_speed = _fill_speed;
        this.undo_timer = _undo_timer;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.max_hole_area);
        buf.writeInt(this.max_diameter);
        buf.writeInt(this.fill_speed);
        buf.writeInt(this.undo_timer);
    }

    public static void handle(ToolTipPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ToolTipPacket.handleOnClient(msg)));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(ToolTipPacket msg) {
        ClientConfig.fill_speed = msg.fill_speed;
        ClientConfig.max_hole_volume = msg.max_hole_area;
        ClientConfig.max_hole_diameter = msg.max_diameter;
        ClientConfig.undo_timer = msg.undo_timer;
    }
}

