/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class H {
    private static final DecimalFormat df = new DecimalFormat("0.00");
    public static ArrayList<Vec3i> DirectionVectors = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, -1, 0), new Vec3i(0, 1, 0)));
    public static ArrayList<Vec3i> HDirectionVectors = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)));

    public static String TwoDP(double num) {
        return df.format(num);
    }

    public static ResourceLocation ResLoc(String id) {
        return new ResourceLocation("hole_filler_mod", id);
    }

    public static Vec3i Vec3iFromDouble(double x, double y, double z) {
        return new Vec3i((int)x, (int)y, (int)z);
    }

    public static BlockPos BlockPosFromDouble(double x, double y, double z) {
        return new BlockPos(H.Vec3iFromDouble(x, y, z));
    }

    public static Vec3i GetDirection(Directions dir) {
        int index = dir.ordinal();
        return DirectionVectors.get(index);
    }

    public static Vec3i Multiply(Vec3i vec, float a) {
        float x = (float)vec.m_123341_() * a;
        float y = (float)vec.m_123342_() * a;
        float z = (float)vec.m_123343_() * a;
        return H.Vec3iFromDouble(x, y, z);
    }

    public static Vec3i DivideAndRound(Vec3i vec, float a) {
        float x = (float)vec.m_123341_() / a;
        float y = (float)vec.m_123342_() / a;
        float z = (float)vec.m_123343_() / a;
        return new Vec3i(Math.round(x), Math.round(y), Math.round(z));
    }

    public static Vec3i Opposite(Vec3i vec) {
        return H.Multiply(vec, -1.0f);
    }

    public static Vec3i Add(Vec3i vec, Vec3i vec2) {
        float x = vec.m_123341_() + vec2.m_123341_();
        float y = vec.m_123342_() + vec2.m_123342_();
        float z = vec.m_123343_() + vec2.m_123343_();
        return H.Vec3iFromDouble(x, y, z);
    }

    public static Vec3i Subtract(Vec3i vec, Vec3i vec2) {
        float x = vec.m_123341_() - vec2.m_123341_();
        float y = vec.m_123342_() - vec2.m_123342_();
        float z = vec.m_123343_() - vec2.m_123343_();
        return H.Vec3iFromDouble(x, y, z);
    }

    public static double Magnitude(Vec3i vec) {
        double total = Math.pow(vec.m_123341_(), 2.0) + Math.pow(vec.m_123342_(), 2.0) + Math.pow(vec.m_123343_(), 2.0);
        double ans = Math.sqrt(total);
        return ans;
    }

    public static ArrayList<Vec3i> RandomDirectionOrder() {
        ArrayList copy = (ArrayList)DirectionVectors.clone();
        Collections.shuffle(copy);
        return copy;
    }

    public static Vec3i GetCentreFromBounds(Vector<Vec3i> vecs) {
        int minX = H.MinVecValue(vecs, 0);
        int minY = H.MinVecValue(vecs, 1);
        int minZ = H.MinVecValue(vecs, 2);
        int maxX = H.MaxVecValue(vecs, 0);
        int maxY = H.MaxVecValue(vecs, 1);
        int maxZ = H.MaxVecValue(vecs, 2);
        int centreX = Math.round((float)(minX + maxX) * 0.5f);
        int centreY = Math.round((float)(minY + maxY) * 0.5f);
        int centreZ = Math.round((float)(minZ + maxZ) * 0.5f);
        return new Vec3i(centreX, centreY, centreZ);
    }

    public static int MinVecValue(Vector<Vec3i> vecs, int index) {
        int min = 999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            int[] array = H.ToArray(vec);
            int value = array[index];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int MaxVecValue(Vector<Vec3i> vecs, int index) {
        int max = -999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            int[] array = H.ToArray(vec);
            int value = array[index];
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static String ToString(BlockPos pos) {
        String s = "[x: " + pos.m_123341_() + ", y: " + pos.m_123342_() + ", z: " + pos.m_123343_() + "]";
        return s;
    }

    public static BlockPos Convert(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static int[] ToArray(Vec3i vec) {
        return new int[]{vec.m_123341_(), vec.m_123342_(), vec.m_123343_()};
    }

    public static int Map(int n, int a, int b, int x, int y) {
        return x + (n - a) * (y - x) / (b - a);
    }

    public static double GetDistance(Vec3 vec1, Vec3 vec2) {
        if (vec1 == null || vec2 == null) {
            return 0.0;
        }
        double xDif = Math.abs(vec1.f_82479_ - vec2.f_82479_);
        double yDif = Math.abs(vec1.f_82480_ - vec2.f_82480_);
        double zDif = Math.abs(vec1.f_82481_ - vec2.f_82481_);
        double total = Math.pow(xDif, 2.0) + Math.pow(yDif, 2.0) + Math.pow(zDif, 2.0);
        double ans = Math.sqrt(total);
        return ans;
    }

    public static double GetDistance(Vec3i vec1, Vec3i vec2) {
        return H.GetDistance(H.Vec3d(vec1), H.Vec3d(vec2));
    }

    public static Vec3 Vec3d(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3 Vec3d(Vec3i pos) {
        if (pos == null) {
            return null;
        }
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3i Convert(BlockPos pos) {
        return new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static Vector<Vec3i> GetNeighbourPositions(Vec3i vec) {
        ArrayList<Vec3i> dirs = DirectionVectors;
        Vector<Vec3i> list = new Vector<Vec3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            list.add(H.Add(vec, dir));
        }
        return list;
    }

    public static Vector<Vec3i> GetSameBlockNeighbours(Level world, Vec3i vec) {
        Block thisBlock = world.m_8055_(new BlockPos(vec)).m_60734_();
        ArrayList<Vec3i> dirs = DirectionVectors;
        Vector<Vec3i> list = new Vector<Vec3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            Vec3i pos = H.Add(vec, dir);
            if (world.m_8055_(new BlockPos(pos)).m_60734_() != thisBlock) continue;
            list.add(pos);
        }
        return list;
    }

    public static Vector<Vec3i> GetSameBlockVein(Level world, Vec3i vec) {
        Vector<Vec3i> list = new Vector<Vec3i>();
        Block thisBlock = world.m_8055_(new BlockPos(vec)).m_60734_();
        list.add(vec);
        int size = list.size();
        int maxLoop = 100;
        int loop = 0;
        while (loop++ < maxLoop) {
            for (int i = 0; i < size; ++i) {
                Vector<Vec3i> neighbours = H.GetSameBlockNeighbours(world, list.get(i));
                for (int j = 0; j < neighbours.size(); ++j) {
                    if (list.contains(neighbours.get(j))) continue;
                    list.add(neighbours.get(j));
                }
            }
            if (size == list.size()) break;
            size = list.size();
        }
        return list;
    }

    public static Vec3i WorldPosToBlockPos(double x, double y, double z) {
        int x1 = (int)Math.round(x + 0.5);
        int y1 = (int)Math.round(y + 0.5);
        int z1 = (int)Math.round(z + 0.5);
        return new Vec3i(x1, y1, z1);
    }

    public static Vec3i WorldPosToBlockPos(Vec3 vec) {
        int x1 = (int)Math.round(vec.f_82479_);
        int y1 = (int)Math.round(vec.f_82480_ - 0.5);
        int z1 = (int)Math.round(vec.f_82481_);
        return new Vec3i(x1, y1, z1);
    }

    public static float Clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static UUID GetPlayerID(Player player) {
        if (player == null) {
            return null;
        }
        return player.m_36316_().getId();
    }

    public static String GetPlayerIDString(Player player) {
        if (player == null) {
            return "";
        }
        return player.m_36316_().getId().toString();
    }

    public static Player GetPlayerFromID(Level world, UUID id) {
        if (world == null || world.f_46443_ || id == null) {
            return null;
        }
        return world.m_7654_().m_6846_().m_11259_(id);
    }

    public static Player GetPlayerFromIDString(Level world, String id) {
        if (world.f_46443_ || id.isEmpty()) {
            return null;
        }
        return world.m_7654_().m_6846_().m_11259_(UUID.fromString(id));
    }

    public static Block BlockFromName(String name) {
        ResourceLocation res = new ResourceLocation(name);
        return (Block)ForgeRegistries.BLOCKS.getValue(res);
    }

    public static ItemStack Single(Block block) {
        if (block == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)block.m_5456_(), 1);
    }

    public static void Drop(Level world, boolean creative, Block block, double x, double y, double z) {
        if (block == null) {
            return;
        }
        ItemStack stack = H.Single(block);
        if (creative) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        if (block == Blocks.f_50493_ && ((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue()) {
            return;
        }
        world.m_7967_((Entity)new ItemEntity(world, x, y, z, stack));
    }

    public static void Drop(Level world, boolean creative, Block block, int count, double x, double y, double z) {
        if (block == null) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)block.m_5456_(), count);
        if (creative) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        if (block == Blocks.f_50493_ && ((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue()) {
            return;
        }
        world.m_7967_((Entity)new ItemEntity(world, x, y, z, stack));
    }

    public static String GetRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).toString();
    }

    public static String GetRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).toString();
    }

    public static enum Directions {
        down,
        up,
        xMinus,
        xPlus,
        zMinus,
        zPlus;

    }
}

