/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util.smart;

import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BlurredBlock {
    public Vec3i pos;
    public HashMap<Block, Float> blockScores = new HashMap();
    public HashMap<Block, Float> tempScores = new HashMap();
    public Block mimic = null;

    public BlurredBlock(Vec3i _pos) {
        this.pos = _pos;
    }

    public Block Best() {
        Map.Entry<Block, Float> maxEntry = null;
        for (Map.Entry<Block, Float> entry : this.blockScores.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return maxEntry != null ? (Block)maxEntry.getKey() : null;
    }

    public void ApplyMimic() {
        this.mimic = this.Best();
    }

    public void RemoveLast() {
        Map.Entry<Block, Float> maxEntry = null;
        for (Map.Entry<Block, Float> entry : this.blockScores.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) >= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            this.blockScores.remove(maxEntry.getKey());
        }
    }

    public HashMap<Block, Float> GetNewSurroundingsPopularity(Level world, int kernelSize, HashMap<Vec3i, BlurredBlock> map, int pass) {
        HashMap<Block, Float> scores = new HashMap<Block, Float>();
        int halfKernel = kernelSize / 2;
        float multi = (float)(Math.pow(halfKernel * 2 + 1, 3.0) * (double)9.1f);
        double blocksFound = Math.pow(halfKernel * 2 + 1, 3.0);
        double multiBlockCount = Math.pow(halfKernel * 2 + 1, 2.0);
        double multiBlockValue = multiBlockCount * (double)multi;
        blocksFound = blocksFound + multiBlockValue - multiBlockCount;
        for (int i = -halfKernel; i <= halfKernel; ++i) {
            for (int j = -halfKernel; j <= halfKernel; ++j) {
                float multiplier = j == 0 ? multi : 1.0f;
                for (int k = -halfKernel; k <= halfKernel; ++k) {
                    BlurredBlock currentBBlock;
                    Vec3i offset = new Vec3i(i, j, k);
                    Vec3i target = H.Add(this.pos, offset);
                    BlockPos bPos = new BlockPos(target);
                    if (HoleUtil.IsValidSelectableBlock(world, bPos)) {
                        float value = 1.0f * multiplier;
                        Block block = world.m_8055_(bPos).m_60734_();
                        scores.computeIfPresent(block, (a, b) -> Float.valueOf(b.floatValue() + value));
                        scores.putIfAbsent(block, Float.valueOf(value));
                        continue;
                    }
                    if (!HoleUtil.IsReplaceableBlock(world, bPos) || (currentBBlock = (BlurredBlock)map.getOrDefault(target, null)) == null) continue;
                    for (Map.Entry<Block, Float> entry : currentBBlock.blockScores.entrySet()) {
                        float val = entry.getValue().floatValue() * multiplier;
                        Block block = entry.getKey();
                        scores.computeIfPresent(block, (a, b) -> Float.valueOf(b.floatValue() + val));
                        scores.putIfAbsent(block, Float.valueOf(val));
                    }
                }
            }
        }
        for (Map.Entry entry : scores.entrySet()) {
            entry.setValue(Float.valueOf(((Float)entry.getValue()).floatValue() / (float)blocksFound));
        }
        this.tempScores = scores;
        return scores;
    }

    public void UpdateScores() {
        Map.Entry<Block, Float> maxEntry = null;
        for (Map.Entry<Block, Float> entry : this.tempScores.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            float maxValue = ((Float)maxEntry.getValue()).floatValue();
            for (Map.Entry<Block, Float> entry : this.tempScores.entrySet()) {
                this.blockScores.put(entry.getKey(), Float.valueOf(entry.getValue().floatValue() / maxValue));
            }
        }
    }
}

