/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.api.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.item.CSArmorMaterials;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.compat.spellbooks.ISSArmorUtil;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.registry.CSAttributes;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.manager.CSIntegrationManager;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;

public class CSArmorItem
extends ArmorItem
implements CSWeaponUtil {
    public CSArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == this.f_265916_.m_266308_() ? this.modifiedAttributes() : super.m_7167_(pEquipmentSlot);
    }

    public void createExtraAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> additional, UUID uuid) {
        if (this.f_40379_ == CSArmorMaterials.SOLAR_CRYSTAL) {
            additional.put((Object)((Attribute)CSAttributes.CELESTIAL_DAMAGE.get()), (Object)new AttributeModifier(uuid, "Armor celestial damage", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
            additional.put((Object)((Attribute)CSAttributes.CELESTIAL_DAMAGE_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Armor celestial damage reduction", 0.025, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (this.f_40379_ == CSArmorMaterials.LUNAR_STONE) {
            additional.put((Object)((Attribute)CSAttributes.CELESTIAL_DAMAGE.get()), (Object)new AttributeModifier(uuid, "Armor celestial damage", 0.025, AttributeModifier.Operation.MULTIPLY_BASE));
            additional.put((Object)((Attribute)CSAttributes.CELESTIAL_DAMAGE_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Armor celestial damage reduction", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public static void hurtWearer(LivingHurtEvent event) {
        int lunarCount;
        LivingEntity entity = event.getEntity();
        int solarCount = CSArmorItem.getSameArmorCount(entity, CSArmorMaterials.SOLAR_CRYSTAL);
        if (solarCount > 0) {
            CSEffectEntity.createInstance(entity, (Entity)entity, (CSVisualType)CSVisualTypes.SOLAR_EXPLOSION.get(), 0.0, 0.75, 0.0);
            entity.m_9236_().m_6269_(null, (Entity)entity, (SoundEvent)CSSoundEvents.SWORD_SWING_FIRE.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
            int i = 0;
            while ((double)i < 22.5) {
                Vec3 delta = new Vec3(0.0, 0.0, 0.0).m_82520_((double)Mth.m_14031_((float)i), 0.0, (double)Mth.m_14089_((float)i)).m_82490_(0.25);
                ParticleUtil.sendParticle(entity.m_9236_(), (SimpleParticleType)CSParticleTypes.SOLARIS_FLAME.get(), entity.m_20182_().m_82520_(0.0, 1.5, 0.0), delta);
                ++i;
            }
            for (LivingEntity targets : entity.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(2.0, 0.0, 2.0)).stream().filter(en -> en != entity).toList()) {
                targets.m_6469_(entity.m_269291_().m_269549_(), (float)solarCount * 1.2f);
                targets.m_20254_(1 + solarCount);
            }
        }
        if ((lunarCount = CSArmorItem.getSameArmorCount(entity, CSArmorMaterials.LUNAR_STONE)) > 0 && entity.m_217043_().m_188503_(6) == 0) {
            entity.m_9236_().m_6269_(null, (Entity)entity, SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, 1.0f);
            int i = 0;
            while ((double)i < 22.5) {
                Vec3 delta = new Vec3(0.0, 0.0, 0.0).m_82520_((double)Mth.m_14031_((float)i), 0.0, (double)Mth.m_14089_((float)i)).m_82490_(0.25);
                ParticleUtil.sendParticle(entity.m_9236_(), ParticleTypes.f_123809_, entity.m_20182_().m_82520_(0.0, 1.5, 0.0), delta);
                ++i;
            }
            event.setAmount(event.getAmount() - (float)lunarCount * 1.5f);
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (this.f_40379_ == CSArmorMaterials.SOLAR_CRYSTAL) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.celestisynth.solar_crystal_armor_bonus").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        if (this.f_40379_ == CSArmorMaterials.LUNAR_STONE) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.celestisynth.lunar_stone_armor_bonus").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    public static int getSameArmorCount(LivingEntity wearer, ArmorMaterial armorMaterial) {
        int i = 0;
        for (ItemStack slot : wearer.m_6168_()) {
            ArmorItem armor;
            Item item = slot.m_41720_();
            if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != armorMaterial) continue;
            ++i;
        }
        return i;
    }

    public Multimap<Attribute, AttributeModifier> modifiedAttributes() {
        ImmutableMultimap.Builder additional = ImmutableMultimap.builder();
        UUID uuid = (UUID)f_265987_.get(this.f_265916_);
        additional.putAll(this.f_40383_);
        this.createExtraAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)additional, uuid);
        if (CSIntegrationManager.checkIronsSpellbooks()) {
            ISSArmorUtil.addSpellbookAttributesOnArmor((ImmutableMultimap.Builder<Attribute, AttributeModifier>)additional, uuid, this.f_40379_);
        }
        return additional.build();
    }
}

