/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.client.renderers.misc.tooltips;

import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.thecelestialworkshop.celestisynth.Celestisynth;
import org.thecelestialworkshop.celestisynth.util.ExtraUtil;
import software.bernie.geckolib.core.object.Color;

public class AbilityComponent {

    public static enum Side {
        SKILL("skill"),
        PASSIVE("passive");

        public final String asText;

        private Side(String asText) {
            this.asText = asText;
        }

        public String getAsText() {
            return this.asText;
        }
    }

    public record Renderer(Data data) implements ClientTooltipComponent
    {
        public static final int DESC_WRAP_WIDTH = 320;
        public static final int ICON_HEIGHT = 16;
        public static final int ICON_OFFSETED_HEIGHT = 24;

        public int m_142103_() {
            return this.descriptionWordWrapHeight() + this.getConditionHeight() + 24 + 13;
        }

        public int m_142069_(Font pFont) {
            return 256;
        }

        public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
            Matrix4f copyMatrix = new Matrix4f((Matrix4fc)pMatrix);
            copyMatrix.translate((float)pMouseX, (float)pMouseY, 0.0f);
            copyMatrix.scale(0.8f);
            copyMatrix.translate((float)(-pMouseX), (float)(-pMouseY), 0.0f);
            if (this.data.side() == Side.SKILL) {
                pFont.m_272077_(this.highlightedCondition(), (float)pMouseX, (float)(pMouseY + 24 + 4), -1, true, copyMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            pFont.m_272077_(this.highlightedName(), (float)pMouseX, (float)(pMouseY + this.getConditionHeight() + 24), -1, true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            this.drawWordWrap(pFont, (FormattedText)this.highlightedDescription(), pMouseX, pMouseY + this.getConditionHeight() + 24 + 10, 320, -1, pMatrix, pBufferSource);
        }

        public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
            int order = 0;
            for (int i = 1; i < this.data.totalAbilityAmount() + 1; ++i) {
                if (i != this.data.highlightedAbilityIndex()) {
                    pGuiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
                }
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_252880_((float)(pX + order), (float)pY, 0.0f);
                pGuiGraphics.m_280168_().m_85841_(0.65f, 0.65f, 0.65f);
                if (i == this.data.highlightedAbilityIndex()) {
                    int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
                    pGuiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)((float)tickCount * 0.075f)) * 2.0f));
                }
                pGuiGraphics.m_280168_().m_252880_((float)(-pX + order), (float)(-pY), 0.0f);
                ResourceLocation icon = Celestisynth.prefix("textures/abilityicon/" + this.data.side().getAsText() + "/" + this.data.itemName() + "_" + this.data.side().getAsText() + "_icon_" + i + ".png");
                ResourceLocation substituteIcon = Celestisynth.prefix("textures/abilityicon/default_ability_icon.png");
                pGuiGraphics.m_280163_(this.checkIcon(icon) ? icon : substituteIcon, pX + order, pY - 4, 0.0f, 0.0f, 32, 32, 32, 32);
                pGuiGraphics.m_280168_().m_85849_();
                pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                order += 12;
            }
            pGuiGraphics.m_280509_(pX - 10, pY + 24 - 3, pX + this.m_142069_(pFont) + 10, pY + this.getConditionHeight() + 24 + this.descriptionWordWrapHeight() + 9, Color.BLACK.argbInt());
            pGuiGraphics.m_280637_(pX - 10, pY + 24 - 4, this.m_142069_(pFont) + 20, this.getConditionHeight() + this.descriptionWordWrapHeight() + 13, Color.WHITE.argbInt());
        }

        public boolean checkIcon(ResourceLocation icon) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            Optional resource = resourceManager.m_213713_(icon);
            return resource.isPresent();
        }

        public int getConditionHeight() {
            return this.data.side() == Side.SKILL ? 7 : 0;
        }

        public Component highlightedName() {
            int tickCount = (int)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.5);
            return Component.m_237115_((String)("item.celestisynth." + this.data.itemName() + "." + this.data.side().getAsText() + "_" + this.data.highlightedAbilityIndex())).m_130948_(Style.f_131099_.m_178520_(ExtraUtil.getCelestialColor(tickCount).argbInt()));
        }

        public Component highlightedDescription() {
            String extension = this.data.side() == Side.PASSIVE ? ".passive_desc_" : ".desc_";
            return Component.m_237115_((String)("item.celestisynth." + this.data.itemName() + extension + this.data.highlightedAbilityIndex())).m_130948_(Style.f_131099_.m_178520_(Color.GRAY.argbInt()));
        }

        public Component highlightedCondition() {
            return Component.m_237115_((String)("item.celestisynth." + this.data.itemName() + ".condition_" + this.data.highlightedAbilityIndex())).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(Color.DARK_GRAY.argbInt()));
        }

        public int descriptionWordWrapHeight() {
            return Minecraft.m_91087_().f_91062_.m_239133_((FormattedText)this.highlightedDescription(), 320);
        }

        public void drawWordWrap(Font pFont, FormattedText pText, int pX, int pY, int pLineWidth, int pColor, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
            for (FormattedCharSequence formattedcharsequence : pFont.m_92923_(pText, pLineWidth)) {
                Matrix4f copyMatrix = new Matrix4f((Matrix4fc)pMatrix);
                copyMatrix.translate((float)pX, (float)pY, 0.0f);
                copyMatrix.scale(0.8f);
                copyMatrix.translate((float)(-pX), (float)(-pY), 0.0f);
                pFont.m_272191_(formattedcharsequence, (float)pX, (float)pY, pColor, true, copyMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                pY += 9;
            }
        }
    }

    public record Data(String itemName, int totalAbilityAmount, int highlightedAbilityIndex, Side side) implements TooltipComponent
    {
    }
}

