/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.attack.cresentia;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.CrescentiaDragon;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import software.bernie.geckolib.core.object.Color;

public class CrescentiaDragonAttack
extends WeaponAttackInstance {
    public CrescentiaDragonAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_CRESCENTIA_THROW.get();
    }

    @Override
    public int getCooldown() {
        return 60;
    }

    @Override
    public int getAttackStopTime() {
        return 30;
    }

    @Override
    public boolean getCondition() {
        return this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        this.useAndDamageItem(this.getStack(), this.level, (LivingEntity)this.player, 5);
        this.chantMessage((Entity)this.player, "crescentia2", 30, Color.WHITE.argbInt());
    }

    @Override
    public void tickAttack() {
        if (this.getTimerProgress() <= 20) {
            this.setDeltaPlayer(this.player, 0.0, 0.0, 0.0);
        }
        if (this.getTimerProgress() == 20) {
            this.chantMessage((Entity)this.player, "crescentia3", 20, Color.PINK.argbInt());
            FloatArrayList angles = new FloatArrayList();
            angles.add(0.0f);
            angles.add(-30.0f);
            angles.add(30.0f);
            if (this.stack.getEnchantmentLevel(Enchantments.f_44959_) > 0) {
                angles.add(-15.0f);
                angles.add(15.0f);
            }
            FloatListIterator floatListIterator = angles.iterator();
            while (floatListIterator.hasNext()) {
                float i = ((Float)floatListIterator.next()).floatValue();
                CrescentiaDragon dragon = new CrescentiaDragon((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.CRESCENTIA_DRAGON.get()), (LivingEntity)this.player, this.level);
                dragon.m_6027_(this.player.m_20185_(), dragon.m_20186_(), this.player.m_20189_());
                Vec3 vec31 = this.player.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(i * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = this.player.m_20252_(1.0f);
                Vector3f shootAngle = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                dragon.m_6686_(shootAngle.x, shootAngle.y, shootAngle.z, 1.5f, 0.0f);
                dragon.damage = this.calculateAttributeDependentDamage((LivingEntity)this.player, this.stack, 0.08f);
                this.level.m_7967_((Entity)dragon);
            }
            this.player.m_5496_(SoundEvents.f_11880_, 1.0f, 2.0f + (float)(this.level.f_46441_.m_188583_() * 0.25));
            this.player.m_5496_(SoundEvents.f_11895_, 1.0f, 0.5f + (float)(this.level.f_46441_.m_188583_() * 0.25));
            this.player.m_5496_((SoundEvent)CSSoundEvents.WHIRLWIND.get(), 0.2f, 0.5f + (float)(this.level.f_46441_.m_188583_() * 0.25));
        }
    }

    @Override
    public void stopUsing() {
    }
}

