/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.attack.frostbound;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.AttackHurtTypes;
import org.thecelestialworkshop.celestisynth.common.attack.frostbound.FrostboundAttack;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;

public class FrostboundDanceAttack
extends FrostboundAttack {
    public FrostboundDanceAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_FROSTBOUND_TRIPLE_SLASH.get();
    }

    @Override
    public int getCooldown() {
        return 160;
    }

    @Override
    public int getAttackStopTime() {
        return 50;
    }

    @Override
    public boolean getCondition() {
        return !this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        this.player.m_20334_(0.0, 0.75, 0.0);
        this.player.m_216990_((SoundEvent)CSSoundEvents.HOP.get());
    }

    @Override
    public void tickAttack() {
        double xP = this.calculateXLook((LivingEntity)this.player) * 1.5;
        double zP = this.calculateZLook((LivingEntity)this.player) * 1.5;
        if (this.getTimerProgress() == 12) {
            this.performImpact(xP, zP);
            this.shootShard(4);
        }
        if (this.getTimerProgress() == 20) {
            this.performIceSlash(0, xP, zP);
            this.shootShard(3);
        } else if (this.getTimerProgress() == 30) {
            this.performIceSlash(1, xP, zP);
            this.shootShard(3);
        } else if (this.getTimerProgress() == 40) {
            this.performIceSlash(2, xP, zP);
            this.shootShard(6);
        }
    }

    public void performImpact(double xOffset, double zOffset) {
        Pair sound = Pair.of((Object)((SoundEvent)CSSoundEvents.SWORD_CLASH.get()), (Object)SoundEvents.f_144205_);
        SimpleParticleType particle = ParticleTypes.f_175821_;
        CSVisualType impact = (CSVisualType)CSVisualTypes.FROSTBOUND_IMPACT_CRACK.get();
        BlockPos groundPos = this.getFloorPositionUnderPlayer(this.level, this.player.m_20183_());
        this.player.m_20334_(0.0, (double)groundPos.m_123342_() - this.player.m_20186_(), 0.0);
        this.playSoundAt(this.level, SoundEvents.f_11983_, groundPos);
        this.playSoundAt(this.level, (SoundEvent)sound.getFirst(), groundPos);
        CSEffectEntity.createInstanceLockedPos((LivingEntity)this.player, null, impact, this.player.m_20185_() + xOffset, (double)groundPos.m_123342_() - 0.75, this.player.m_20189_() + zOffset);
        for (int i = 0; i < 360; i += 4) {
            double xI = xOffset + (double)(Mth.m_14031_((float)i) * 3.0f);
            double zI = zOffset + (double)(Mth.m_14089_((float)i) * 3.0f);
            ParticleUtil.sendParticles(this.level, particle, this.player.m_20185_() + xI, (double)groundPos.m_123342_() + 1.5, this.player.m_20189_() + zI, 1, xI / 5.0, 0.0, zI / 5.0);
        }
        if (this.level.m_5776_()) {
            this.shakeScreens(this.player, 5, 4, 0.0015f);
        }
        for (Entity entity : this.iterateEntities(this.level, this.createAABB((Vec3i)groundPos.m_7918_((int)xOffset, 1, (int)zOffset), 6.0, 3.0))) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity == this.player) continue;
            this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 1.5f, AttackHurtTypes.REGULAR);
            CSEntityCapabilityProvider.get(target).ifPresent(data -> data.setFrostbound(100));
            entity.m_216990_((SoundEvent)sound.getSecond());
        }
    }

    public void performIceSlash(int slashIndex, double xOffset, double zOffset) {
        Pair sound = Pair.of((Object)((SoundEvent)CSSoundEvents.FROZEN_SLASH.get()), (Object)SoundEvents.f_12324_);
        SimpleParticleType particle = ParticleTypes.f_175821_;
        CSVisualType slash = switch (slashIndex) {
            default -> (CSVisualType)CSVisualTypes.FROSTBOUND_SLASH.get();
            case 1 -> (CSVisualType)CSVisualTypes.FROSTBOUND_SLASH_INVERTED.get();
            case 2 -> (CSVisualType)CSVisualTypes.FROSTBOUND_SLASH_LARGE.get();
        };
        this.playSoundAt(this.level, (SoundEvent)sound.getFirst(), this.player.m_20183_().m_7918_((int)xOffset, 0, (int)zOffset));
        CSEffectEntity.createInstance((LivingEntity)this.player, (Entity)this.player, slash, xOffset, slashIndex == 2 ? 0.15 : 0.25, zOffset);
        for (int i = 0; i < 360; i += 4) {
            double sizeMult = slashIndex == 2 ? 1.5 : 0.5;
            double xI = xOffset + (double)(Mth.m_14031_((float)i) * 3.0f);
            double zI = zOffset + (double)(Mth.m_14089_((float)i) * 3.0f);
            ParticleUtil.sendParticle(this.level, particle, this.player.m_20185_() + xI, this.player.m_20186_() + 0.5, this.player.m_20189_() + zI, (double)Mth.m_14031_((float)i) * sizeMult, 0.0, (double)Mth.m_14089_((float)i) * sizeMult);
        }
        for (Entity entity : this.iterateEntities(this.level, this.createAABB((Vec3i)this.player.m_20183_().m_7918_((int)xOffset, 1, (int)zOffset), slashIndex == 2 ? 8.0 : 5.0, 3.0))) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity == this.player) continue;
            this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 1.7f, AttackHurtTypes.REGULAR);
            CSEntityCapabilityProvider.get(target).ifPresent(data -> data.setFrostbound(60));
            entity.m_216990_((SoundEvent)sound.getSecond());
        }
        this.player.m_20334_(this.calculateXLook((LivingEntity)this.player) * 1.5, 0.25, this.calculateZLook((LivingEntity)this.player) * 1.5);
    }

    @Override
    public void stopUsing() {
    }
}

