/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.attack.solaris;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.AttackHurtTypes;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;
import software.bernie.geckolib.core.object.Color;

public class SolarisFullRoundAttack
extends WeaponAttackInstance {
    public static final String DIRECTION_INDEX_KEY = "cs.directionIndex";

    public SolarisFullRoundAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_SOLARIS_SPIN.get();
    }

    @Override
    public int getCooldown() {
        return 70;
    }

    @Override
    public int getAttackStopTime() {
        return 80;
    }

    @Override
    public boolean getCondition() {
        return !this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        this.getTagController().m_128405_(DIRECTION_INDEX_KEY, this.player.m_217043_().m_188503_(2));
        this.useAndDamageItem(this.getStack(), this.level, (LivingEntity)this.player, 2);
        this.chantMessage((Entity)this.player, "solaris", 30, Color.WHITE.argbInt());
    }

    @Override
    public void stopUsing() {
        this.getTagController().m_128405_(DIRECTION_INDEX_KEY, this.player.m_217043_().m_188503_(2));
    }

    @Override
    public void tickAttack() {
        if (this.getTimerProgress() == 13) {
            this.player.m_216990_((SoundEvent)CSSoundEvents.STEP.get());
            for (int i = 0; i < 15; ++i) {
                RandomSource rand = this.level.f_46441_;
                ParticleUtil.sendParticles(this.level, ParticleTypes.f_123755_, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 0, (double)(-1.0f + rand.m_188501_() * 2.0f) * 0.5, 0.1, (double)(-1.0f + rand.m_188501_() * 2.0f) * 0.5);
            }
        }
        if (this.getTimerProgress() == 23) {
            this.chantMessage((Entity)this.player, "solaris1", 20, Color.ORANGE.argbInt());
        }
        if (this.getTimerProgress() > 0 && this.getTimerProgress() < 24) {
            ParticleUtil.sendParticles(this.level, ParticleTypes.f_123744_, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 0, 0.0, 0.1, 0.0);
            this.player.m_20334_(0.0, 0.0, 0.0);
            this.player.f_19864_ = true;
        } else if (this.getTimerProgress() > 23 && this.getTimerProgress() < 60) {
            BlockPos blockPosForAttack = this.player.m_20183_();
            int range = 4;
            List entities = this.level.m_45976_(LivingEntity.class, new AABB(blockPosForAttack.m_7918_(-range, -range, -range), blockPosForAttack.m_7918_(range, range, range)));
            for (LivingEntity target : entities) {
                if (target == this.player || this.player.m_7307_((Entity)target) || !target.m_6084_()) continue;
                this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 0.23f, AttackHurtTypes.RAPID_NO_KB);
                target.m_20254_(5);
            }
            if (this.getTagController().m_128451_(DIRECTION_INDEX_KEY) == 0) {
                this.movePlayerInCircularMotion(this.player, this.getTimerProgress(), false);
            } else if (this.getTagController().m_128451_(DIRECTION_INDEX_KEY) == 1) {
                this.movePlayerInCircularMotion(this.player, this.getTimerProgress(), true);
            }
            CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.SOLARIS_BLITZ.get(), 0.0, 2.5, 0.0);
            CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.SOLARIS_AIR.get());
            this.dashSound(1.0 + this.player.m_217043_().m_188583_() / 2.0);
            BlockPos playerPos = this.player.m_20183_();
            double radius = 3.0;
            double particleCount = 30.0;
            double angleIncrement = Math.PI * 2 / particleCount;
            int i = 0;
            while ((double)i < particleCount) {
                double angle = (double)i * angleIncrement;
                double rotationX = this.level.f_46441_.m_188500_() * 360.0;
                double rotationZ = this.level.f_46441_.m_188500_() * 360.0;
                double x = (double)playerPos.m_123341_() + radius * Math.cos(angle);
                double y = (double)playerPos.m_123342_() + 1.5;
                double z = (double)playerPos.m_123343_() + radius * Math.sin(angle);
                double motionX = Math.sin(Math.toRadians(rotationX)) * Math.cos(Math.toRadians(rotationZ));
                double motionY = Math.sin(Math.toRadians(rotationZ));
                double motionZ = Math.cos(Math.toRadians(rotationX)) * Math.cos(Math.toRadians(rotationZ));
                if (!this.level.m_5776_()) {
                    ParticleUtil.sendParticles(this.level, ParticleTypes.f_123744_, x + 0.5, y, z + 0.5, 0, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private void dashSound(double pitch) {
        if (this.player.m_217043_().m_188499_()) {
            if (this.player.m_217043_().m_188499_()) {
                this.player.m_5496_((SoundEvent)CSSoundEvents.SWORD_SWING.get(), 0.2f, (float)pitch);
            } else {
                this.player.m_5496_((SoundEvent)CSSoundEvents.AIR_SWING.get(), 0.2f, (float)pitch);
            }
        } else if (this.player.m_217043_().m_188499_()) {
            this.player.m_5496_((SoundEvent)CSSoundEvents.SWORD_SWING_FIRE.get(), 0.2f, (float)pitch);
        } else {
            this.player.m_5496_((SoundEvent)CSSoundEvents.IMPACT_HIT.get(), 0.2f, (float)pitch);
        }
    }

    private void movePlayerInCircularMotion(Player player, int tick, boolean isRight) {
        double radius = 1.5;
        double forwardX = Math.sin(Math.toRadians(player.m_146908_()));
        double forwardZ = -Math.cos(Math.toRadians(player.m_146908_()));
        double perpendicularX = -forwardZ;
        double perpendicularZ = forwardX;
        double angle = (double)(tick - 45) / 25.0 * Math.PI * 2.0;
        double offsetX = radius * Math.cos(angle);
        double offsetZ = radius * Math.sin(angle);
        double finalX = isRight ? player.m_20185_() + forwardX * offsetX - perpendicularX * offsetZ : player.m_20185_() + forwardX * offsetX + perpendicularX * offsetZ;
        double finalZ = isRight ? player.m_20189_() + forwardZ * offsetX - perpendicularZ * offsetZ : player.m_20189_() + forwardZ * offsetX + perpendicularZ * offsetZ;
        player.m_20334_(finalX - player.m_20185_(), player.m_20184_().f_82480_, finalZ - player.m_20189_());
    }
}

