/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.base;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;

public abstract class EffectControllerEntity
extends Entity
implements CSWeaponUtil,
OwnableEntity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> ORIGIN_ITEM = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> ANGLE_X = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Y = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_Z = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_X = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Y = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGLE_ADD_Z = SynchedEntityData.m_135353_(EffectControllerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final SoundEvent[] BASE_WEAPON_EFFECTS = new SoundEvent[]{(SoundEvent)CSSoundEvents.SWORD_SWING.get(), (SoundEvent)CSSoundEvents.SWORD_SWING_FIRE.get(), (SoundEvent)CSSoundEvents.AIR_SWING.get(), (SoundEvent)CSSoundEvents.SWORD_CLASH.get(), (SoundEvent)CSSoundEvents.FIRE_SHOOT.get(), (SoundEvent)CSSoundEvents.IMPACT_HIT.get()};
    public float damage;

    public EffectControllerEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        Player ownerPlayer;
        super.m_8119_();
        UUID ownerUuid = this.m_21805_();
        Player player = ownerPlayer = ownerUuid == null ? null : this.m_9236_().m_46003_(ownerUuid);
        if (ownerPlayer == null || ownerPlayer.m_21224_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ORIGIN_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ANGLE_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ANGLE_ADD_Z, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7380_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public int getDisappearRange() {
        return 64;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        double range = this.getDisappearRange();
        List surroundingEntities = this.m_9236_().m_45976_(Entity.class, new AABB(this.m_20185_() + range, this.m_20186_() + range, this.m_20189_() + range, this.m_20185_() - range, this.m_20186_() - range, this.m_20189_() - range));
        for (Entity entityBatch : surroundingEntities) {
            CSEffectEntity effect;
            if (!(entityBatch instanceof CSEffectEntity) || (effect = (CSEffectEntity)entityBatch).getToFollow() != this) continue;
            effect.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_142687_(pReason);
    }

    public void setOwner(Player player) {
        this.setOwnerUUID(player.m_20148_());
    }

    public void setOwnerUUID(@Nullable UUID ownerUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOriginItem(ItemStack stack) {
        this.f_19804_.m_135381_(ORIGIN_ITEM, (Object)stack);
    }

    public ItemStack getOriginItem() {
        return (ItemStack)this.f_19804_.m_135370_(ORIGIN_ITEM);
    }

    public void setAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_X, (Object)Float.valueOf(angleX));
    }

    public float getAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_X)).floatValue();
    }

    public void setAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_Y, (Object)Float.valueOf(angleY));
    }

    public float getAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Y)).floatValue();
    }

    public void setAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_Z)).floatValue();
    }

    public void setAddAngleX(float angleX) {
        this.f_19804_.m_135381_(ANGLE_ADD_X, (Object)Float.valueOf(angleX));
    }

    public float getAddAngleX() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_X)).floatValue();
    }

    public void setAddAngleY(float angleY) {
        this.f_19804_.m_135381_(ANGLE_ADD_Y, (Object)Float.valueOf(angleY));
    }

    public float getAddAngleY() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Y)).floatValue();
    }

    public void setAddAngleZ(float angleZ) {
        this.f_19804_.m_135381_(ANGLE_ADD_Z, (Object)Float.valueOf(angleZ));
    }

    public float getAddAngleZ() {
        return ((Float)this.f_19804_.m_135370_(ANGLE_ADD_Z)).floatValue();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

