/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.mob.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.entity.base.FixedMovesetEntity;
import org.thecelestialworkshop.celestisynth.common.entity.base.MonolithSummonedEntity;
import org.thecelestialworkshop.celestisynth.common.entity.goals.star_monolith.StarMonolithSpikeGoal;
import org.thecelestialworkshop.celestisynth.common.entity.helper.MonolithRunes;
import org.thecelestialworkshop.celestisynth.common.registry.CSItems;
import org.thecelestialworkshop.celestisynth.common.registry.CSTags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarMonolith
extends Mob
implements GeoEntity,
FixedMovesetEntity,
CSWeaponUtil {
    private static final EntityDataAccessor<Integer> ACTION = SynchedEntityData.m_135353_(StarMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(StarMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(StarMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RUNE = SynchedEntityData.m_135353_(StarMonolith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int ACTION_SPIKE = 1;
    public static final int VARIANT_OVERWORLD = 0;
    public static final int VARIANT_NETHER = 1;
    public static final int VARIANT_END = 2;

    public StarMonolith(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new StarMonolithSpikeGoal(this));
    }

    public void m_8119_() {
        List<BlockPos> validSpawns;
        int summoned;
        super.m_8119_();
        this.getRune().ambientTick.accept(this, this.m_9236_());
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46791_() != Difficulty.PEACEFUL && this.hasNearbyAlivePlayerWithFilter(this.m_20185_(), this.m_20186_(), this.m_20189_(), 128.0) && this.getRune().summonInterval > 0 && this.f_19797_ % this.getRune().summonInterval == 0 && (summoned = StreamSupport.stream(((ServerLevel)this.m_9236_()).m_8583_().spliterator(), false).filter(e -> {
            MonolithSummonedEntity summonedEntity;
            return e instanceof MonolithSummonedEntity && (summonedEntity = (MonolithSummonedEntity)e).getMonolith() == this;
        }).toList().size()) < this.getRune().summonLimit && !(validSpawns = this.getValidSpawnPoints(this.getRune().summonRange)).isEmpty()) {
            for (BlockPos targetPos : this.getRandomBlockPositionsWithinList(validSpawns, this.getRune().summonClusterSize)) {
                this.getRune().summonAction.accept((Object)this, (Object)targetPos, (Object)((ServerLevel)this.m_9236_()));
            }
        }
    }

    public List<BlockPos> getRandomBlockPositionsWithinList(List<BlockPos> posList, int listSize) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (int i = 0; i < listSize; ++i) {
            poses.add(posList.get(this.f_19796_.m_188503_(posList.size())));
        }
        return poses.stream().toList();
    }

    public boolean hasNearbyAlivePlayerWithFilter(double pX, double pY, double pZ, double pDistance) {
        for (Player player : this.m_9236_().m_6907_()) {
            if (!EntitySelector.f_20408_.test(player) || !EntitySelector.f_20403_.test(player) || !this.m_142582_((Entity)player)) continue;
            double distanceOfPlayer = player.m_20275_(pX, pY, pZ);
            if (!(pDistance < 0.0) && !(distanceOfPlayer < pDistance * pDistance)) continue;
            return true;
        }
        return false;
    }

    public List<BlockPos> getValidSpawnPoints(int range) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int xx = -range; xx <= range; ++xx) {
            for (int yy = -range; yy <= range; ++yy) {
                for (int zz = -range; zz <= range; ++zz) {
                    BlockPos toAddPos = this.m_20183_().m_7918_(xx, yy, zz);
                    if (!this.m_9236_().m_8055_(toAddPos.m_7495_()).m_60783_((BlockGetter)this.m_9236_(), toAddPos.m_7495_(), Direction.UP) || !this.m_9236_().m_8055_(toAddPos).m_60795_() || !this.hasLineOfSight(toAddPos)) continue;
                    blockPositions.add(toAddPos);
                }
            }
        }
        return blockPositions;
    }

    public boolean hasLineOfSight(BlockPos pos) {
        Vec3 vec3 = this.m_20182_();
        Vec3 vec31 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (this.getAction() == 1) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.star_monolith.spike"));
            }
            if (this.m_21224_()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.star_monolith.death"));
            }
            if (this.getRune() != MonolithRunes.NO_RUNE) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.star_monolith.idle"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.star_monolith.off"));
        })});
    }

    public static boolean canSpawn(EntityType<StarMonolith> pEntityType, ServerLevelAccessor pServerLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return StarMonolith.m_217057_(pEntityType, (LevelAccessor)pServerLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    protected boolean m_8028_() {
        return true;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_20035_(this.getFloorPositionUnderPlayer(this.m_9236_(), this.m_20183_()).m_7494_(), 0.0f, 0.0f);
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        for (Map.Entry<TagKey<Item>, MonolithRunes> activatorEntry : MonolithRunes.ACTIVATORS_LIST.entrySet()) {
            if (!stack.m_204117_(activatorEntry.getKey())) continue;
            this.setRune(activatorEntry.getValue());
            if (!pPlayer.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11736_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)CSItems.CELESTIAL_DEBUGGER.get())) {
            this.setRune(MonolithRunes.APOCALYPTIC_RUNE);
            this.m_21051_(Attributes.f_22276_).m_22100_(1024.0);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22284_).m_22100_(1024.0);
            this.m_5496_(SoundEvents.f_12555_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.NATURAL || pReason == MobSpawnType.STRUCTURE || pReason == MobSpawnType.CHUNK_GENERATION) {
            if (this.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
                this.setVariant(0);
                if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207603_) || pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207602_)) {
                    this.setRune(MonolithRunes.AQUA_RUNE);
                }
            }
            if (this.m_9236_().m_46472_().equals((Object)Level.f_46429_)) {
                this.setVariant(1);
                if (this.isInCurrentStructure(CSTags.Structures.NETHER_MONOLITH_SPAWN)) {
                    this.setRune(MonolithRunes.BLOOD_RUNE);
                }
            }
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean isInCurrentStructure(ResourceKey<Structure> structure) {
        ServerLevel server;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && (server = (ServerLevel)level).m_215010_().m_220488_(this.m_20183_(), structure).m_73603_();
    }

    public boolean isInCurrentStructure(TagKey<Structure> structureTag) {
        ServerLevel server;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && (server = (ServerLevel)level).m_215010_().m_220491_(this.m_20183_(), structureTag).m_73603_();
    }

    public boolean m_21532_() {
        return false;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11704_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11738_;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.resetAction();
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(pCompound.m_128451_("variant"));
        this.setRune(MonolithRunes.values()[pCompound.m_128451_("rune")]);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("variant", this.getVariant());
        pCompound.m_128405_("rune", this.getRune().ordinal());
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setRune(MonolithRunes rune) {
        this.f_19804_.m_135381_(RUNE, (Object)rune.ordinal());
    }

    public MonolithRunes getRune() {
        return MonolithRunes.values()[(Integer)this.f_19804_.m_135370_(RUNE)];
    }

    @Override
    public void setAction(int action) {
        this.f_19804_.m_135381_(ACTION, (Object)action);
    }

    @Override
    public int getAction() {
        return (Integer)this.f_19804_.m_135370_(ACTION);
    }

    @Override
    public int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    @Override
    public void setAnimationTick(int tick) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)tick);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTION, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
        this.f_19804_.m_135372_(RUNE, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int m_6062_() {
        return Integer.MAX_VALUE;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void m_20256_(Vec3 motionIn) {
        super.m_20256_(Vec3.f_82478_.m_82520_(0.0, -0.3, 0.0));
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_5834_() {
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }
}

