/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.KeresSlash;
import org.thecelestialworkshop.celestisynth.common.registry.CSDamageSources;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.util.EntityUtil;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;

public class KeresShadow
extends ThrowableProjectile
implements CSWeaponUtil {
    private static final EntityDataAccessor<Integer> HOMING_TARGET = SynchedEntityData.m_135353_(KeresShadow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float damage;

    public KeresShadow(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public KeresShadow(EntityType<? extends ThrowableProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        double xx = this.f_19796_.m_188583_() * 0.02;
        double yy = this.f_19796_.m_188583_() * 0.02;
        double zz = this.f_19796_.m_188583_() * 0.02;
        Vec3 offsetVector = this.m_20184_().m_82541_().m_82490_(4.0);
        ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.KERES_ASH.get(), this.m_20185_() + offsetVector.m_7096_(), this.m_20186_() + offsetVector.m_7098_() + 1.0, this.m_20189_() + offsetVector.m_7094_(), xx, yy, zz);
        if (this.getHomingTarget() != null) {
            Vec3 positionAmends = this.getHomingTarget().m_20182_().m_82546_(this.m_20182_());
            double posAmendScale = 0.05;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(positionAmends.m_82541_().m_82490_(posAmendScale)));
            if (this.m_20191_().m_82400_(1.0).m_82381_(this.getHomingTarget().m_20191_())) {
                this.m_5790_(new EntityHitResult((Entity)this.getHomingTarget()));
            }
        } else {
            TargetingConditions selectFreshTarget = TargetingConditions.m_148352_().m_26883_(128.0).m_148355_().m_26888_(living -> living != this.m_19749_() && EntityUtil.isNotAPetOf(this.m_19749_(), living));
            List targetList = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(32.0), entity -> selectFreshTarget.m_26885_(null, entity));
            if (!targetList.isEmpty()) {
                this.setHomingTarget((LivingEntity)targetList.get(this.f_19796_.m_188503_(targetList.size())));
            } else {
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)entity2;
                    if (this.f_19797_ >= 20) {
                        this.setHomingTarget(owner);
                    }
                } else {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                if (target == owner) {
                    owner.m_5634_(1.0f);
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        player.m_36324_().m_38707_(2, 0.0f);
                    }
                    owner.m_216990_(SoundEvents.f_144242_);
                } else {
                    target.m_6469_(CSDamageSources.instance(this.m_9236_()).rapidPlayerAttack(owner), this.damage);
                    target.m_5496_(SoundEvents.f_12555_, 0.2f, 1.0f + this.f_19796_.m_188501_() * 0.5f);
                    KeresSlash slash = new KeresSlash((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.KERES_SLASH.get()), owner, this.m_9236_());
                    double d0 = target.m_20185_() - owner.m_20185_();
                    double d1 = target.m_20186_() - owner.m_20186_();
                    double d2 = target.m_20189_() - owner.m_20189_();
                    slash.setRoll((float)(this.f_19796_.m_188583_() * 360.0));
                    slash.m_20219_(owner.m_20182_());
                    slash.baseDamage = this.damage / 2.0f;
                    slash.m_6686_(d0, d1, d2, 2.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)slash);
                    this.m_9236_().m_5594_(null, owner.m_20183_(), (SoundEvent)CSSoundEvents.SLASH_WATER.get(), SoundSource.PLAYERS, 0.02f, (float)(1.5 + this.m_9236_().f_46441_.m_188500_() * 0.5));
                }
                if (target == this.getHomingTarget()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Nullable
    public LivingEntity getHomingTarget() {
        int data = (Integer)this.f_19804_.m_135370_(HOMING_TARGET);
        if (data == 0) {
            return null;
        }
        Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(HOMING_TARGET)).intValue());
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            return living;
        }
        return null;
    }

    public void setHomingTarget(LivingEntity target) {
        this.f_19804_.m_135381_(HOMING_TARGET, (Object)target.m_19879_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HOMING_TARGET, (Object)0);
    }
}

