/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.network.s2c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.thecelestialworkshop.celestisynth.Celestisynth;

public class UpdateGroupedParticlePacket {
    private final double x;
    private final double y;
    private final double z;
    private final float xDist;
    private final float yDist;
    private final float zDist;
    private final float xSpeed;
    private final float ySpeed;
    private final float zSpeed;
    private final int count;
    private final boolean overrideLimiter;
    private final ParticleType<?> particle;

    public <T extends ParticleType<?>> UpdateGroupedParticlePacket(T pParticle, boolean pOverrideLimiter, double pX, double pY, double pZ, float pXDist, float pYDist, float pZDist, float xSpeed, float ySpeed, float zSpeed, int pCount) {
        this.particle = pParticle;
        this.overrideLimiter = pOverrideLimiter;
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.xDist = pXDist;
        this.yDist = pYDist;
        this.zDist = pZDist;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.count = pCount;
    }

    public UpdateGroupedParticlePacket(FriendlyByteBuf buffer) {
        ParticleType particletype = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.m_130281_());
        this.overrideLimiter = buffer.readBoolean();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.xDist = buffer.readFloat();
        this.yDist = buffer.readFloat();
        this.zDist = buffer.readFloat();
        this.xSpeed = buffer.readFloat();
        this.ySpeed = buffer.readFloat();
        this.zSpeed = buffer.readFloat();
        this.count = buffer.readInt();
        this.particle = particletype;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.PARTICLE_TYPES.getKey(this.particle));
        buffer.writeBoolean(this.overrideLimiter);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.xDist);
        buffer.writeFloat(this.yDist);
        buffer.writeFloat(this.zDist);
        buffer.writeFloat(this.xSpeed);
        buffer.writeFloat(this.ySpeed);
        buffer.writeFloat(this.zSpeed);
        buffer.writeInt(this.count);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return false;
        }
        if (this.count == 0) {
            try {
                minecraft.f_91073_.m_6485_((ParticleOptions)this.particle, true, this.x, this.y, this.z, (double)this.xSpeed, (double)this.ySpeed, (double)this.zSpeed);
            }
            catch (Throwable throwable1) {
                Celestisynth.LOGGER.warn("Could not spawn particle effect {}", this.particle);
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                double xOffset = minecraft.f_91073_.f_46441_.m_188583_() * (double)this.xDist;
                double yOffset = minecraft.f_91073_.f_46441_.m_188583_() * (double)this.yDist;
                double zOffset = minecraft.f_91073_.f_46441_.m_188583_() * (double)this.zDist;
                try {
                    minecraft.f_91073_.m_6485_((ParticleOptions)this.particle, true, this.x + xOffset, this.y + yOffset, this.z + zOffset, (double)this.xSpeed, (double)this.ySpeed, (double)this.zSpeed);
                    continue;
                }
                catch (Throwable throwable) {
                    Celestisynth.LOGGER.warn("Could not spawn particle effect {}", this.particle);
                }
            }
        }
        return true;
    }
}

