/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.registry;

import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.thecelestialworkshop.celestisynth.common.compat.spellbooks.ISSCompatItems;
import org.thecelestialworkshop.celestisynth.common.registry.CSBlocks;
import org.thecelestialworkshop.celestisynth.common.registry.CSEnchantments;
import org.thecelestialworkshop.celestisynth.common.registry.CSItems;
import org.thecelestialworkshop.celestisynth.manager.CSIntegrationManager;

public class CSCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"celestisynth");
    public static final RegistryObject<CreativeModeTab> CELESTISYNTH = CREATIVE_MODE_TABS.register("celestisynth_tab", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)CSItems.FROSTBOUND.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.celestisynth_tab")).m_257501_((pParameters, pOutput) -> {
        CSCreativeTabs.acceptItemRegistry(pOutput, CSItems.ITEMS.getEntries());
        CSCreativeTabs.acceptBlockRegistry(pOutput, CSBlocks.BLOCKS.getEntries());
        CSCreativeTabs.acceptEnchantmentRegistry(pOutput, CSEnchantments.ENCHANTMENTS.getEntries());
        if (CSIntegrationManager.checkIronsSpellbooks()) {
            CSCreativeTabs.acceptItemRegistry(pOutput, ISSCompatItems.SPELLBOOKS_ITEMS.getEntries());
        }
    }).m_257652_());

    public static void acceptItemRegistry(CreativeModeTab.Output output, Collection<RegistryObject<Item>> registry) {
        for (RegistryObject<Item> item : registry) {
            if (CSCreativeTabs.getBlackList().contains(item)) continue;
            output.m_246326_((ItemLike)item.get());
        }
    }

    public static void acceptBlockRegistry(CreativeModeTab.Output output, Collection<RegistryObject<Block>> registry) {
        for (RegistryObject<Block> block : registry) {
            if (CSCreativeTabs.getBlackList().contains(block)) continue;
            output.m_246326_((ItemLike)block.get());
        }
    }

    public static void acceptEnchantmentRegistry(CreativeModeTab.Output output, Collection<RegistryObject<Enchantment>> registry) {
        for (RegistryObject<Enchantment> enchantment : registry) {
            if (CSCreativeTabs.getEnchantmentBlackList().contains(enchantment)) continue;
            for (int i = ((Enchantment)enchantment.get()).m_44702_(); i <= ((Enchantment)enchantment.get()).m_6586_(); ++i) {
                output.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment.get(), i)));
            }
        }
    }

    public static List<RegistryObject<? extends ItemLike>> getBlackList() {
        return List.of(CSItems.TEMPEST_SPAWN_EGG, CSItems.CELESTIAL_DEBUGGER);
    }

    public static List<RegistryObject<Enchantment>> getEnchantmentBlackList() {
        return List.of();
    }
}

