/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.datagen.helpers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import org.thecelestialworkshop.celestisynth.Celestisynth;

public class BlockDatagenHelper {
    public static final ResourceLocation RENDER_TYPE_CUTOUT = new ResourceLocation("cutout");
    public static final ResourceLocation RENDER_TYPE_TRANSLUCENT = new ResourceLocation("translucent");
    private final BlockStateProvider state;
    private final BlockModelProvider model;

    public BlockDatagenHelper(BlockModelProvider modelProvider, BlockStateProvider stateProvider) {
        this.state = stateProvider;
        this.model = modelProvider;
    }

    public void cubeAll(Block block) {
        this.baseModel(block, (BlockModelBuilder)this.model.cubeAll(BlockDatagenHelper.name(block), BlockDatagenHelper.csLoc(BlockDatagenHelper.name(block))));
    }

    public void cubeAll(Block block, ResourceLocation renderType) {
        this.baseModel(block, (BlockModelBuilder)((BlockModelBuilder)this.model.cubeAll(BlockDatagenHelper.name(block), BlockDatagenHelper.csLoc(BlockDatagenHelper.name(block)))).renderType(renderType));
    }

    public void crossRotatable(Block block, ResourceLocation renderType) {
        this.state.directionalBlock(block, (ModelFile)((BlockModelBuilder)this.model.cross(BlockDatagenHelper.name(block), BlockDatagenHelper.csLoc(BlockDatagenHelper.name(block)))).renderType(renderType));
    }

    public void baseModel(Block block, BlockModelBuilder model) {
        this.state.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    public static ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static String name(Block block) {
        return BlockDatagenHelper.key(block).m_135815_();
    }

    public static ResourceLocation csLoc(String name) {
        return Celestisynth.prefix("block/" + name);
    }
}

