/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.datagen.providers;

import java.util.ArrayList;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.thecelestialworkshop.celestisynth.common.registry.CSLootTables;
import org.thecelestialworkshop.celestisynth.datagen.helpers.MergeLootTablesModifier;

public class CSGlobalLootModifiersProvider
extends GlobalLootModifierProvider {
    public CSGlobalLootModifiersProvider(PackOutput output) {
        super(output, "celestisynth");
    }

    protected void start() {
        this.add("underground_dungeons_modifier", (IGlobalLootModifier)new MergeLootTablesModifier(new LootItemCondition[]{LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_153976_(Level.f_46428_)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])this.allValidDungeonTables()).m_6409_()}, CSLootTables.UNDERGROUND_DUNGEONS.location));
        this.add("nether_structures_modifier", (IGlobalLootModifier)new MergeLootTablesModifier(new LootItemCondition[]{LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_153976_(Level.f_46429_)).m_6409_(), AnyOfCondition.m_285758_((LootItemCondition.Builder[])this.allValidNetherStructureTables()).m_6409_()}, CSLootTables.VANILLA_NETHER_STRUCTURES.location));
    }

    public LootTableIdCondition.Builder[] allValidDungeonTables() {
        ArrayList<LootTableIdCondition.Builder> builderList = new ArrayList<LootTableIdCondition.Builder>();
        builderList.add(this.lootId("chests/ancient_city"));
        builderList.add(this.lootId("chests/abandoned_mineshaft"));
        String modid = "betterdungeons";
        builderList.add(this.lootId(modid, "zombie_dungeon/chests/common"));
        builderList.add(this.lootId(modid, "skeleton_dungeon/chests/common"));
        builderList.add(this.lootId(modid, "spider_dungeon/chests/egg_room"));
        return builderList.toArray(new LootTableIdCondition.Builder[0]);
    }

    public LootTableIdCondition.Builder[] allValidNetherStructureTables() {
        ArrayList<LootTableIdCondition.Builder> builderList = new ArrayList<LootTableIdCondition.Builder>();
        builderList.add(this.lootId("chests/nether_bridge"));
        builderList.add(this.lootId("chests/ruined_portal"));
        builderList.add(this.lootId("chests/bastion_bridge"));
        builderList.add(this.lootId("chests/bastion_hoglin_stable"));
        builderList.add(this.lootId("chests/bastion_other"));
        builderList.add(this.lootId("chests/bastion_treasure"));
        String ignoredModid = "";
        return builderList.toArray(new LootTableIdCondition.Builder[0]);
    }

    public LootTableIdCondition.Builder lootId(String location) {
        return LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(location));
    }

    public LootTableIdCondition.Builder lootId(String modid, String location) {
        return LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(modid, location));
    }
}

