/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.history.change;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;

public class BiomeChange3D
implements Change {
    private final BlockVector3 position;
    private final BiomeType previous;
    private final BiomeType current;

    public BiomeChange3D(BlockVector3 position, BiomeType previous, BiomeType current) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)previous);
        Preconditions.checkNotNull((Object)current);
        this.position = position;
        this.previous = previous;
        this.current = current;
    }

    public BlockVector3 getPosition() {
        return this.position;
    }

    public BiomeType getPrevious() {
        return this.previous;
    }

    public BiomeType getCurrent() {
        return this.current;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        ((Extent)Preconditions.checkNotNull((Object)context.getExtent())).setBiome(this.position, this.previous);
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        ((Extent)Preconditions.checkNotNull((Object)context.getExtent())).setBiome(this.position, this.current);
    }
}

