/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.api.util.NetworkUtil;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class EditClipboardPacket {
    Level level;
    final int addIndex;
    final CapturedBlocks captured;
    final int removeIndex;

    public EditClipboardPacket(@Nullable Level level, int addIndex, @Nullable CapturedBlocks captured, int removeIndex) {
        this.level = level;
        this.addIndex = addIndex;
        this.captured = captured;
        this.removeIndex = removeIndex;
    }

    public static void encoder(EditClipboardPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.addIndex);
        if (packet.addIndex > -1 && packet.captured != null) {
            CompoundTag tag = packet.captured.toCompressedTag(packet.level.m_9598_());
            NetworkUtil.writeCompressedNbt(buff, tag);
        }
        buff.writeInt(packet.removeIndex);
    }

    public static EditClipboardPacket decoder(FriendlyByteBuf buff) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompoundTag tag;
            int addIndex = buff.readInt();
            CapturedBlocks captured = null;
            if (addIndex > -1 && (tag = NetworkUtil.readCompressedNbt(buff, () -> null)) != null) {
                captured = CapturedBlocks.fromCompressedTag(Minecraft.m_91087_().f_91073_.m_9598_(), tag);
            }
            int removeIndex = buff.readInt();
            return new EditClipboardPacket(null, addIndex, captured, removeIndex);
        }
        return new EditClipboardPacket(null, -1, null, -1);
    }

    public static void handler(EditClipboardPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                EditClipboardPacket.handleClient(packet, (NetworkEvent.Context)context.get());
            }
        });
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(EditClipboardPacket packet, NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BuildingToolPlayerData data = StructureGelMod.proxy.getBuildingToolData(player.m_9236_(), player.m_36316_().getName());
        if (packet.addIndex > -1 && packet.captured != null) {
            data.addToClipboardDirect(packet.addIndex, packet.captured);
        }
        if (packet.removeIndex > -1) {
            data.removeFromClipboard(packet.removeIndex);
        }
    }
}

