/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.cc;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.cc.CCBlockEntity;
import com.tom.morewires.compat.cc.ICCTile;
import com.tom.morewires.tile.IOnCable;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CCConnectorBlockEntity
extends CCBlockEntity
implements IOnCable.IOnCableConnector,
ICCTile {
    protected GlobalWireNetwork globalNet;
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final WiredElement cable = new CableElement();
    private LazyOptional<WiredElement> elementCap;
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token((BlockEntity)this);
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess((BlockEntity)this, x -> this.connectionsChanged());
    private boolean isUnloaded = false;

    public CCConnectorBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public BlockState getState() {
        return this.m_58900_();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.f_58858_, 0));
        if (local != null && !local.getConnections(this.f_58858_).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.CC_WIRE.simple().wireType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.m_6596_();
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public Level getLevelNonnull() {
        return this.f_58857_;
    }

    public void m_142339_(Level worldIn) {
        super.m_142339_(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
        this.onRemove();
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.f_58857_);
        this.isUnloaded = false;
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.f_58857_, (IImmersiveConnectable)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        this.onRemove();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CAPABILITY_WIRED_ELEMENT) {
            if (this.destroyed || side != this.getFacing()) {
                return LazyOptional.empty();
            }
            if (this.elementCap == null) {
                this.elementCap = LazyOptional.of(() -> this.cable);
            }
            return this.elementCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private void onRemove() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.onRemove();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
    }

    void connectionsChanged() {
        Direction facing;
        BlockPos current;
        BlockPos offset;
        if (this.m_58904_().f_46443_) {
            return;
        }
        Level world = this.m_58904_();
        if (!world.m_46749_(offset = (current = this.m_58899_()).m_121945_(facing = this.getFacing()))) {
            return;
        }
        WiredElement element = (WiredElement)this.connectedElements.get(facing);
        if (element == null) {
            return;
        }
        WiredNode node = element.getNode();
        this.node.connectTo(node);
    }

    @Override
    public void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
        }
    }

    @Override
    public WiredElement getElement() {
        return this.cable;
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    @Override
    public void onNeighbourTileEntityChange(BlockPos neighbour) {
        super.onNeighbourTileEntityChange(neighbour);
        if (!this.f_58857_.f_46443_) {
            TickScheduler.schedule((TickScheduler.Token)this.tickToken);
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.CC_WIRE.simple().NET_ID);
    }

    private class CableElement
    implements WiredElement {
        private final WiredNode node = ComputerCraftAPI.createWiredNodeForElement((WiredElement)this);

        private CableElement() {
        }

        public Level getLevel() {
            return CCConnectorBlockEntity.this.m_58904_();
        }

        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)CCConnectorBlockEntity.this.m_58899_());
        }

        public WiredNode getNode() {
            return this.node;
        }

        public String getSenderID() {
            return "miw_connector";
        }
    }
}

