/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.network;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public abstract class NodeNetworkHandler<C, N>
extends LocalNetworkHandler
implements IWorldTickable {
    protected boolean gridInitialized;
    protected boolean needRefresh;
    private Set<C> connections = new HashSet<C>();
    private Set<ChunkPos> proxyChunks = new HashSet<ChunkPos>();

    protected NodeNetworkHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    private void reset() {
        this.connections.forEach(this::clearConnection);
        this.connections.clear();
        this.needRefresh = true;
    }

    protected abstract void clearConnection(C var1);

    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        this.reset();
        return this;
    }

    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectionAdded(Connection c) {
        this.reset();
    }

    public void onConnectionRemoved(Connection c) {
        this.reset();
    }

    public void update(Level w) {
        block5: {
            block7: {
                block6: {
                    if (this.gridInitialized) break block6;
                    this.gridInitialized = true;
                    this.initNode(w);
                    this.needRefresh = true;
                    break block5;
                }
                if (!this.needRefresh) break block7;
                this.needRefresh = false;
                N main = this.getNode();
                if (main == null) break block5;
                boolean first = true;
                this.proxyChunks.clear();
                this.connections.forEach(this::clearConnection);
                this.connections.clear();
                for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
                    C c;
                    IImmersiveConnectable iic = this.localNet.getConnector(cp);
                    if (iic.isProxy()) {
                        this.proxyChunks.add(new ChunkPos(iic.getPosition()));
                        continue;
                    }
                    if (first) {
                        first = false;
                        this.connectFirst(iic, main);
                    }
                    if ((c = this.connect(iic, main)) == null) continue;
                    this.connections.add(c);
                }
                break block5;
            }
            if (w.m_46467_() % 10L == 0L) {
                for (ChunkPos p : this.proxyChunks) {
                    if (!w.m_7726_().m_5563_(p.f_45578_, p.f_45579_)) continue;
                    this.reset();
                    break;
                }
            }
        }
    }

    protected void initNode(Level level) {
    }

    protected abstract N getNode();

    protected abstract C connect(IImmersiveConnectable var1, N var2);

    protected abstract void connectFirst(IImmersiveConnectable var1, N var2);
}

