/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.particles.fluidparticle;

import com.direwolf20.buildinggadgets2.client.particles.fluidparticle.FluidFlowParticleData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidFlowParticle
extends BreakingItemParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    Random f_107223_ = new Random();
    private float partSize;
    private boolean doGravity;
    private boolean shrinking;
    private FluidStack fluidStack;
    public static ParticleProvider<FluidFlowParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new FluidFlowParticle(world, x, y, z, data.getFluidStack(), data.doGravity, data.shrinking);

    public FluidFlowParticle(ClientLevel world, double x, double y, double z, FluidStack fluidStack, boolean gravity, boolean shrinking) {
        super(world, x, y, z, ItemStack.f_41583_);
        this.fluidStack = fluidStack;
        this.doGravity = gravity;
        this.shrinking = shrinking;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        if (shrinking) {
            this.targetX = x + 1.75;
            this.targetY = y + 1.75;
            this.targetZ = z + 1.75;
        } else {
            double randomX = this.f_107223_.nextFloat();
            double randomY = this.f_107223_.nextFloat();
            double randomZ = this.f_107223_.nextFloat();
            this.f_107209_ = x + randomX;
            this.f_107210_ = y + randomY;
            this.f_107211_ = z + randomZ;
            this.m_107264_(this.f_107209_, this.f_107210_, this.f_107211_);
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
        }
        Vec3 target = new Vec3(this.targetX, this.targetY, this.targetZ);
        Vec3 source = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 path = target.m_82546_(source).m_82541_().m_82542_(1.0, 1.0, 1.0);
        float minSize = 0.25f;
        float maxSize = 0.5f;
        this.partSize = minSize + this.f_107223_.nextFloat() * (maxSize - minSize);
        float speedModifier = 0.5f * (this.partSize - minSize) / (maxSize - minSize) + 0.25f;
        int ticksPerBlock = 15;
        float speedAdjust = (float)ticksPerBlock * (1.0f / speedModifier);
        this.f_107215_ += path.f_82479_ / (double)speedAdjust;
        this.f_107216_ += path.f_82480_ / (double)speedAdjust;
        this.f_107217_ += path.f_82481_ / (double)speedAdjust;
        this.f_107225_ = 30;
        int longLifeChance = this.f_107223_.nextInt(20);
        if (longLifeChance == 0) {
            this.f_107225_ = 120;
        }
        this.m_6569_(this.partSize);
        this.partSize = this.f_107663_;
        this.m_108337_((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack)));
        int i = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        this.f_107227_ *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.f_107228_ *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.f_107229_ *= (float)(i & 0xFF) / 255.0f;
        if (gravity) {
            this.f_107215_ = 0.0;
            this.f_107216_ = 0.0;
            this.f_107217_ = 0.0;
            this.f_107226_ = 0.0625f;
            this.f_107219_ = true;
            this.f_107224_ = this.f_107225_ / 2;
            this.m_6569_(2.0f);
            this.partSize = this.f_107663_;
            this.updateColorAndGravity();
        } else {
            this.f_107226_ = 0.0f;
            this.f_107219_ = false;
        }
        if (!shrinking) {
            this.updateColorAndGravity();
        }
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
        if (!this.shrinking && this.f_107213_ <= this.targetY) {
            this.m_107274_();
        }
        this.updateColorAndGravity();
    }

    public void updateColorAndGravity() {
        float relativeAge = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_;
        float shrink = Mth.m_14179_((float)relativeAge, (float)0.1f, (float)1.0f);
        this.f_107663_ = this.partSize * shrink;
        float adjustedAge = (float)Math.pow(relativeAge, 2.0);
        if (this.shrinking) {
            this.f_107227_ = Mth.m_14179_((float)adjustedAge, (float)0.0f, (float)this.f_107227_);
            this.f_107228_ = Mth.m_14179_((float)adjustedAge, (float)0.0f, (float)this.f_107228_);
            this.f_107229_ = Mth.m_14179_((float)adjustedAge, (float)0.0f, (float)this.f_107229_);
        } else {
            int i = IClientFluidTypeExtensions.of((Fluid)this.fluidStack.getFluid()).getTintColor(this.fluidStack);
            float targetRed = (float)(i >> 16 & 0xFF) / 255.0f;
            float targetGreen = (float)(i >> 8 & 0xFF) / 255.0f;
            float targetBlue = (float)(i & 0xFF) / 255.0f;
            this.f_107227_ = Mth.m_14179_((float)adjustedAge, (float)targetRed, (float)this.f_107227_);
            this.f_107228_ = Mth.m_14179_((float)adjustedAge, (float)targetGreen, (float)this.f_107228_);
            this.f_107229_ = Mth.m_14179_((float)adjustedAge, (float)targetBlue, (float)this.f_107229_);
        }
        if (relativeAge < 0.5f) {
            adjustedAge = (float)Math.pow(relativeAge / 0.5f, 2.0);
            this.f_107230_ = this.shrinking ? Mth.m_14179_((float)adjustedAge, (float)0.4f, (float)1.0f) : Mth.m_14179_((float)adjustedAge, (float)1.0f, (float)0.2f);
        }
        if (!this.doGravity) {
            int gravityChance = this.f_107223_.nextInt(2);
            if (relativeAge < 0.75f && gravityChance == 0) {
                this.f_107226_ = 0.05f;
            }
        }
    }

    protected int m_6355_(float pPartialTick) {
        return 0xF00080;
    }
}

