/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.actuallyadditions;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.actuallyadditions.ActuallyAdditionsHelper;
import thelm.jaopca.compat.actuallyadditions.ActuallyAdditionsModule;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"actuallyadditions"})
public class ActuallyAdditionsLegacyModule
implements IModule {
    @Override
    public String getName() {
        return "actuallyadditions_legacy";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return ActuallyAdditionsModule.BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ActuallyAdditionsHelper helper = ActuallyAdditionsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            if (material.hasExtra(1)) {
                ResourceLocation extraLocation;
                IMaterial extraMaterial = material.getExtra(1);
                if (!itemTags.contains(extraLocation = miscHelper.getTagLocation(switch (extraMaterial.getType()) {
                    case MaterialType.INGOT -> "raw_materials";
                    case MaterialType.INGOT_LEGACY -> "dusts";
                    default -> extraMaterial.getType().getFormName();
                }, extraMaterial.getName()))) continue;
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "actuallyadditions.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, 1.0f, extraLocation, 1, 0.2f);
                continue;
            }
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "actuallyadditions.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, 1.0f);
        }
    }
}

