/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.createmetallurgy;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.createmetallurgy.CreateMetallurgyHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"createmetallurgy"})
public class CreateMetallurgyCompatModule
implements IModule {
    private static final Set<String> MATERIAL_BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "brass", "bronze", "constantan", "copper", "electrum", "gold", "invar", "iron", "lead", "netherite", "nickel", "osmium", "silver", "steel", "tin", "tungsten", "void_steel", "zinc"));
    private static final Set<String> DUST_BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "brass", "bronze", "constantan", "copper", "electrum", "gold", "invar", "iron", "lead", "netherite", "nickel", "osmium", "silver", "steel", "tin", "void_steel", "wolframite", "zinc"));
    private static Set<String> configMaterialToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configDustToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configDirtyDustToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configPlateToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configGearToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configCoinToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configRodToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configWireToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configToStorageBlockBlacklist = new TreeSet<String>();
    private static Set<String> configToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configToRodBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "createmetallurgy_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have ingot melting recipes added."), configMaterialToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget melting recipes added."), configNuggetToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have dust melting recipes added."), configDustToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.plateToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate melting recipes added."), configPlateToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.gearToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear melting recipes added."), configGearToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.coinToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have coin melting recipes added."), configCoinToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.rodToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rod melting recipes added."), configRodToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.wireToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have wire melting recipes added."), configRodToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have ingot casting recipes added."), configToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toStorageBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have storage block casting recipes added."), configToStorageBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget casting recipes added."), configToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate casting recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear casting recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rod casting recipes added."), configToRodBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        CreateMetallurgyHelper helper = CreateMetallurgyHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Set<ResourceLocation> fluidTags = ((JAOPCAApi)api).getFluidTags();
        Item ingotMold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createmetallurgy:graphite_ingot_mold"));
        Item nuggetMold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createmetallurgy:graphite_nugget_mold"));
        Item plateMold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createmetallurgy:graphite_plate_mold"));
        Item gearMold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createmetallurgy:graphite_gear_mold"));
        Item rodMold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("createmetallurgy:graphite_rod_mold"));
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation gearLocation;
            ResourceLocation storageBlockLocation;
            ResourceLocation rodLocation;
            ResourceLocation coinLocation;
            ResourceLocation plateLocation;
            ResourceLocation dustLocation;
            ResourceLocation nuggetLocation;
            ResourceLocation materialLocation;
            int baseAmount;
            MaterialType type = material.getType();
            String name = material.getName();
            boolean isIngot = type.isIngot();
            if (type.isDust()) continue;
            ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", name, "_");
            int n = baseAmount = isIngot ? 90 : 100;
            if (!fluidTags.contains(moltenLocation)) continue;
            if (!MATERIAL_BLACKLIST.contains(name) && !configMaterialToMoltenBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.material_to_molten." + name), materialLocation, moltenLocation, baseAmount, 40, 1);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configNuggetToMoltenBlacklist.contains(name) && itemTags.contains(nuggetLocation = miscHelper.getTagLocation("nuggets", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.nugget_to_molten." + name), nuggetLocation, moltenLocation, (int)Math.floor((float)baseAmount / 9.0f), 4, 1);
            }
            if (!DUST_BLACKLIST.contains(name) && !configDustToMoltenBlacklist.contains(name) && itemTags.contains(dustLocation = miscHelper.getTagLocation("dusts", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.dust_to_molten." + name), dustLocation, moltenLocation, baseAmount, 20, 1);
            }
            if (!DUST_BLACKLIST.contains(name) && !configDirtyDustToMoltenBlacklist.contains(name)) {
                ResourceLocation dirtyDustLocation = miscHelper.getTagLocation("dirty_dusts", name);
                ResourceLocation altDirtyDustLocation = miscHelper.getTagLocation("createmetallurgy:dirty_dusts", name);
                if (itemTags.contains(dirtyDustLocation) || itemTags.contains(altDirtyDustLocation)) {
                    CompoundIngredientObject dirtyDustIngredient = CompoundIngredientObject.union(dirtyDustLocation, altDirtyDustLocation);
                    helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.dirty_dust_to_molten." + name), dirtyDustIngredient, moltenLocation, baseAmount, 35, 1);
                }
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configPlateToMoltenBlacklist.contains(name) && itemTags.contains(plateLocation = miscHelper.getTagLocation("plates", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.plate_to_molten." + name), plateLocation, moltenLocation, baseAmount, 40, 1);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configGearToMoltenBlacklist.contains(name) && itemTags.contains(plateLocation = miscHelper.getTagLocation("gears", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.gear_to_molten." + name), plateLocation, moltenLocation, baseAmount * 4, 160, 1);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configCoinToMoltenBlacklist.contains(name) && itemTags.contains(coinLocation = miscHelper.getTagLocation("coins", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.coin_to_molten." + name), coinLocation, moltenLocation, (int)Math.floor((float)baseAmount / 9.0f), 4, 1);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configRodToMoltenBlacklist.contains(name) && itemTags.contains(rodLocation = miscHelper.getTagLocation("rods", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "createmetallurgy.rod_to_molten." + name), rodLocation, moltenLocation, (int)Math.floor((float)baseAmount / 2.0f), 4, 20);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToMaterialBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_material." + name), ingotMold, moltenLocation, baseAmount, materialLocation, 1, 60, false);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToStorageBlockBlacklist.contains(name) && itemTags.contains(storageBlockLocation = miscHelper.getTagLocation("storage_blocks", name))) {
                helper.registerCastingBasinRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_storage_block." + name), ItemStack.f_41583_, moltenLocation, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), storageBlockLocation, 1, 320, false);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToNuggetBlacklist.contains(name) && itemTags.contains(nuggetLocation = miscHelper.getTagLocation("nuggets", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_nugget." + name), nuggetMold, moltenLocation, (int)Math.ceil((float)baseAmount / 9.0f), nuggetLocation, 1, 10, false);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name) && itemTags.contains(plateLocation = miscHelper.getTagLocation("plates", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_plate." + name), plateMold, moltenLocation, baseAmount, plateLocation, 1, 60, false);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToGearBlacklist.contains(name) && itemTags.contains(gearLocation = miscHelper.getTagLocation("gears", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_gear." + name), gearMold, moltenLocation, baseAmount * 4, gearLocation, 1, 160, false);
            }
            if (MATERIAL_BLACKLIST.contains(name) || configToRodBlacklist.contains(name) || !itemTags.contains(rodLocation = miscHelper.getTagLocation("rods", name))) continue;
            helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "createmetallurgy.molten_to_rod." + name), rodMold, moltenLocation, (int)Math.ceil((float)baseAmount / 2.0f), rodLocation, 1, 30, false);
        }
    }
}

