/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.integrateddynamics.IntegratedDynamicsHelper;
import thelm.jaopca.compat.integrateddynamics.IntegratedDynamicsModule;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"integrateddynamics"})
public class IntegratedDynamicsLegacyModule
implements IModule {
    @Override
    public String getName() {
        return "integrateddynamics_legacy";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return IntegratedDynamicsModule.BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        IntegratedDynamicsHelper helper = IntegratedDynamicsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_dust." + material.getName()), oreLocation, new Object[]{dustLocation, 1, Float.valueOf(1.0f), dustLocation, 1, Float.valueOf(0.75f)});
            helper.registerMechanicalSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_dust_mechanical." + material.getName()), oreLocation, new Object[]{dustLocation, 2, Float.valueOf(1.0f), dustLocation, 1, Float.valueOf(0.5f)}, 40);
        }
    }
}

