/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.JsonHelper;

public class MaterialEnumFunctionDeserializer
implements JsonDeserializer<Function<IMaterial, Enum<?>>> {
    public static final MaterialEnumFunctionDeserializer INSTANCE = new MaterialEnumFunctionDeserializer();

    private MaterialEnumFunctionDeserializer() {
    }

    public Function<IMaterial, Enum<?>> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        Type[] typeArguments = ((ParameterizedType)typeOfT).getActualTypeArguments();
        Type parameterizedType = typeArguments[1];
        if (parameterizedType instanceof Class && ((Class)parameterizedType).isEnum()) {
            Enum[] values;
            TreeMap<String, Enum> stringToEnum = new TreeMap<String, Enum>();
            TreeMap<Enum, String> enumToString = new TreeMap<Enum, String>();
            for (Enum value : values = (Enum[])((Class)parameterizedType).getEnumConstants()) {
                stringToEnum.put(value.name().toLowerCase(Locale.US), value);
                enumToString.put(value, value.name());
            }
            JsonObject json = helper.getJsonObject(jsonElement, "object");
            Enum defaultValue = null;
            if (helper.isString(json, "default")) {
                Enum value;
                String defaultString = helper.getString(json, "default");
                value = (Enum)stringToEnum.get(defaultString.toLowerCase(Locale.US));
                if (value == null) {
                    throw new JsonSyntaxException("Invalid enum " + defaultString);
                }
                defaultValue = value;
            } else if (helper.isNumber(json, "default")) {
                int defaultOrdinal = helper.getInt(json, "default");
                if (defaultOrdinal >= values.length) {
                    throw new JsonSyntaxException("Invalid enum ordinal " + defaultOrdinal);
                }
                defaultValue = values[defaultOrdinal];
            } else {
                throw new JsonSyntaxException("Unable to deserialize enum");
            }
            Object2ObjectRBTreeMap map = new Object2ObjectRBTreeMap();
            map.defaultReturnValue((Object)defaultValue);
            if (json.has("materialTypes")) {
                JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
                for (Map.Entry entry : materialTypesJson.entrySet()) {
                    Enum materialTypeValue;
                    if (helper.isString((JsonElement)entry.getValue())) {
                        String materialTypeString = helper.getString((JsonElement)entry.getValue(), "element");
                        Enum value = (Enum)stringToEnum.get(materialTypeString.toLowerCase(Locale.US));
                        if (value == null) {
                            throw new JsonSyntaxException("Invalid enum " + materialTypeString);
                        }
                        materialTypeValue = value;
                    } else if (helper.isNumber((JsonElement)entry.getValue())) {
                        int materialTypeOrdinal = helper.getInt((JsonElement)entry.getValue(), "element");
                        if (materialTypeOrdinal >= values.length) {
                            throw new JsonSyntaxException("Invalid enum ordinal " + materialTypeOrdinal);
                        }
                        materialTypeValue = values[materialTypeOrdinal];
                    } else {
                        throw new JsonSyntaxException("Unable to deserialize enum");
                    }
                    switch ((String)entry.getKey()) {
                        case "ingot": {
                            MaterialHandler.getMaterials().stream().filter(m -> m.getType().isIngot()).forEach(arg_0 -> MaterialEnumFunctionDeserializer.lambda$deserialize$1((Object2ObjectMap)map, materialTypeValue, arg_0));
                            break;
                        }
                        case "gem": {
                            MaterialHandler.getMaterials().stream().filter(m -> m.getType().isGem()).forEach(arg_0 -> MaterialEnumFunctionDeserializer.lambda$deserialize$3((Object2ObjectMap)map, materialTypeValue, arg_0));
                            break;
                        }
                        case "crystal": {
                            MaterialHandler.getMaterials().stream().filter(m -> m.getType().isCrystal()).forEach(arg_0 -> MaterialEnumFunctionDeserializer.lambda$deserialize$5((Object2ObjectMap)map, materialTypeValue, arg_0));
                            break;
                        }
                        case "dust": {
                            MaterialHandler.getMaterials().stream().filter(m -> m.getType().isDust()).forEach(arg_0 -> MaterialEnumFunctionDeserializer.lambda$deserialize$7((Object2ObjectMap)map, materialTypeValue, arg_0));
                        }
                    }
                }
            }
            if (json.has("materials")) {
                JsonObject materialsJson = helper.getJsonObject(json, "materials");
                for (Map.Entry entry : materialsJson.entrySet()) {
                    Enum materialValue;
                    if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                    if (helper.isString((JsonElement)entry.getValue())) {
                        String materialString = helper.getString((JsonElement)entry.getValue(), "element");
                        Enum value = (Enum)stringToEnum.get(materialString.toLowerCase(Locale.US));
                        if (value == null) {
                            throw new JsonSyntaxException("Invalid enum " + materialString);
                        }
                        materialValue = value;
                    } else if (helper.isNumber((JsonElement)entry.getValue())) {
                        int materialOrdinal = helper.getInt((JsonElement)entry.getValue(), "element");
                        if (materialOrdinal >= values.length) {
                            throw new JsonSyntaxException("Invalid enum ordinal " + materialOrdinal);
                        }
                        materialValue = values[materialOrdinal];
                    } else {
                        throw new JsonSyntaxException("Unable to deserialize enum");
                    }
                    map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), (Object)materialValue);
                }
            }
            if (json.has("config") && helper.getBoolean(json, "config")) {
                String path = helper.getString(json, "path");
                String comment = json.has("comment") ? helper.getString(json, "comment") : "";
                CustomModule.instance.addCustomConfigDefiner((arg_0, arg_1) -> MaterialEnumFunctionDeserializer.lambda$deserialize$8(path, parameterizedType, (Object2ObjectMap)map, comment, arg_0, arg_1));
            }
            return map;
        }
        throw new JsonParseException("Unable to deserialize " + helper.toSimpleString(jsonElement) + " into an enum function");
    }

    private static /* synthetic */ void lambda$deserialize$8(String path, Type parameterizedType, Object2ObjectMap map, String comment, IMaterial material, IDynamicSpecConfig config) {
        Enum value = config.getDefinedEnum(path, (Class)parameterizedType, (Enum)map.get((Object)material), comment);
        if (value != null) {
            map.put((Object)material, (Object)value);
        }
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2ObjectMap map, Enum materialTypeValue, Material m) {
        map.put((Object)m, (Object)materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2ObjectMap map, Enum materialTypeValue, Material m) {
        map.put((Object)m, (Object)materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2ObjectMap map, Enum materialTypeValue, Material m) {
        map.put((Object)m, (Object)materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2ObjectMap map, Enum materialTypeValue, Material m) {
        map.put((Object)m, (Object)materialTypeValue);
    }
}

