/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import thelm.jaopca.api.resources.IInMemoryResourcePack;

public class InMemoryResourcePack
implements IInMemoryResourcePack {
    private static final Gson GSON = new GsonBuilder().create();
    private final String packId;
    private final boolean isHidden;
    private final JsonObject metadata = (JsonObject)JsonParser.parseString((String)"{\"pack_format\":15,\"description\":\"JAOPCA In Memory Resources\"}");
    private final TreeMap<String, Supplier<? extends InputStream>> files = new TreeMap();

    public InMemoryResourcePack(String packId, boolean isHidden) {
        this.packId = packId;
        this.isHidden = isHidden;
    }

    private static String getPath(PackType packType, ResourceLocation location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    @Override
    public IInMemoryResourcePack putInputStream(PackType type, ResourceLocation location, Supplier<? extends InputStream> streamSupplier) {
        this.files.put(InMemoryResourcePack.getPath(type, location), streamSupplier);
        return this;
    }

    @Override
    public IInMemoryResourcePack putInputStreams(PackType type, Map<ResourceLocation, Supplier<? extends InputStream>> map) {
        map.forEach((location, streamSupplier) -> this.files.put(InMemoryResourcePack.getPath(type, location), (Supplier<? extends InputStream>)streamSupplier));
        return this;
    }

    @Override
    public IInMemoryResourcePack putByteArray(PackType type, ResourceLocation location, byte[] file) {
        return this.putInputStream(type, location, () -> new ByteArrayInputStream(file));
    }

    @Override
    public IInMemoryResourcePack putByteArrays(PackType type, Map<ResourceLocation, byte[]> map) {
        return this.putInputStreams(type, Maps.transformValues(map, file -> () -> new ByteArrayInputStream((byte[])file)));
    }

    @Override
    public IInMemoryResourcePack putString(PackType type, ResourceLocation location, String str) {
        return this.putByteArray(type, location, str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public IInMemoryResourcePack putStrings(PackType type, Map<ResourceLocation, String> map) {
        return this.putByteArrays(type, Maps.transformValues(map, str -> str.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public IInMemoryResourcePack putJson(PackType type, ResourceLocation location, JsonElement json) {
        return this.putString(type, location, GSON.toJson(json));
    }

    @Override
    public IInMemoryResourcePack putJsons(PackType type, Map<ResourceLocation, ? extends JsonElement> map) {
        return this.putStrings(type, Maps.transformValues(map, json -> GSON.toJson(json)));
    }

    public IoSupplier<InputStream> m_8017_(String ... path) {
        String filePath = String.join((CharSequence)"/", path);
        return this.files.containsKey(filePath) ? () -> this.files.get(filePath).get() : null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        String filePath = InMemoryResourcePack.getPath(type, location);
        return this.files.containsKey(filePath) ? () -> this.files.get(filePath).get() : null;
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        String prefix = type.m_10305_() + "/" + namespace + "/";
        String prefix1 = prefix + path + "/";
        this.files.forEach((filePath, streamSupplier) -> {
            if (filePath.startsWith(prefix1)) {
                resourceOutput.accept((Object)new ResourceLocation(namespace, filePath.substring(prefix.length())), ((Supplier)streamSupplier)::get);
            }
        });
    }

    public Set<String> m_5698_(PackType type) {
        String prefix = type.m_10305_() + "/";
        return this.files.keySet().stream().filter(filePath -> filePath.startsWith(prefix)).map(filePath -> filePath.substring(prefix.length())).filter(filePath -> filePath.contains("/")).map(filePath -> filePath.substring(0, filePath.indexOf("/"))).collect(Collectors.toSet());
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        return (T)(deserializer == PackMetadataSection.f_243696_ ? deserializer.m_6322_(this.metadata) : null);
    }

    public String m_5542_() {
        return this.packId;
    }

    public boolean m_246538_() {
        return true;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void close() {
    }
}

