/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageFromStorageRecipe
extends ShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapelessRecipe compose;

    public MovingStorageFromStorageRecipe(ShapelessRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.f_44243_, compose.m_7527_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5818_(CraftingContainer input, Level level) {
        return super.m_5818_(input, level) && this.getStorage(input).map(c -> !WoodStorageBlockItem.isPacked((ItemStack)c)).orElse(false) != false;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getStorage(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.m_8020_(slot);
            Item item = slotStack.m_41720_();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof StorageBlockBase)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public ItemStack m_5874_(CraftingContainer input, RegistryAccess registries) {
        ItemStack movingStorageItem = super.m_5874_(input, registries);
        this.getStorage(input).ifPresent(storage -> MovingStorageItem.setStorageItem(movingStorageItem, storage));
        return movingStorageItem;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.MOVING_STORAGE_FROM_STORAGE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, MovingStorageFromStorageRecipe> {
        public Serializer() {
            super(MovingStorageFromStorageRecipe::new, RecipeSerializer.f_44077_);
        }
    }
}

