/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageTierUpgradeShapedRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapedRecipe compose;

    public MovingStorageTierUpgradeShapedRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.m_44220_(), compose.m_44221_(), compose.m_7527_(), compose.f_44149_);
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack m_5874_(CraftingContainer input, RegistryAccess registries) {
        ItemStack upgradedMovingStorage = super.m_5874_(input, registries);
        this.getOriginalMovingStorage(input).ifPresent(originalMovingStorage -> {
            ItemStack originalStorageItem = MovingStorageItem.getStorageItem(originalMovingStorage);
            ItemStack upgradedStorageItem = MovingStorageItem.getStorageItem(upgradedMovingStorage);
            upgradedStorageItem.m_41751_(originalStorageItem.m_41783_());
            NBTHelper.setInteger((ItemStack)upgradedStorageItem, (String)"numberOfInventorySlots", (int)MovingStorageWrapper.getDefaultNumberOfInventorySlots((ItemStack)upgradedStorageItem));
            NBTHelper.setInteger((ItemStack)upgradedStorageItem, (String)"numberOfUpgradeSlots", (int)MovingStorageWrapper.getDefaultNumberOfUpgradeSlots((ItemStack)upgradedStorageItem));
            upgradedMovingStorage.m_41751_(originalMovingStorage.m_41783_());
            MovingStorageItem.setStorageItem(upgradedMovingStorage, upgradedStorageItem);
        });
        return upgradedMovingStorage;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getOriginalMovingStorage(CraftingContainer input) {
        for (int slot = 0; slot < input.m_6643_(); ++slot) {
            ItemStack slotStack = input.m_8020_(slot);
            if (!(slotStack.m_41720_() instanceof MovingStorageItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return ModItems.MOVING_STORAGE_TIER_UPGRADE_SHAPED_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, MovingStorageTierUpgradeShapedRecipe> {
        public Serializer() {
            super(MovingStorageTierUpgradeShapedRecipe::new, RecipeSerializer.f_44076_);
        }
    }
}

