/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;

public class MovingStorageData
extends SavedData
implements IStorageSavedData {
    private static final String SAVED_DATA_PREFIX = "sophisticatedstorageinmotion/";
    private CompoundTag movingStorageContents = new CompoundTag();
    private boolean toRemove = false;
    private static final Map<UUID, MovingStorageData> clientStorageCopy = new HashMap<UUID, MovingStorageData>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MovingStorageData() {
    }

    public static MovingStorageData get(UUID storageId) {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (MovingStorageData)storage.m_164861_(MovingStorageData::load, MovingStorageData::new, SAVED_DATA_PREFIX + String.valueOf(storageId));
        }
        return clientStorageCopy.computeIfAbsent(storageId, id -> new MovingStorageData());
    }

    public static MovingStorageData load(CompoundTag nbt) {
        MovingStorageData storageData = new MovingStorageData();
        storageData.movingStorageContents = nbt;
        return storageData;
    }

    public static void moveToItemStorage(ItemStack storageItem, UUID storageId) {
        MovingStorageData storageData = MovingStorageData.get(storageId);
        CompoundTag contents = storageData.getContents();
        contents.m_128365_("renderInfo", (Tag)NBTHelper.getCompound((ItemStack)storageItem, (String)"renderInfo").orElse(new CompoundTag()));
        CompoundTag fullContents = new CompoundTag();
        fullContents.m_128365_("storageWrapper", (Tag)contents);
        ItemContentsStorage.get().setStorageContents(storageId, fullContents);
        storageData.removeStorageContents();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (this.movingStorageContents != null) {
            return this.movingStorageContents;
        }
        return new CompoundTag();
    }

    public void removeStorageContents() {
        this.toRemove = true;
        this.m_77762_();
    }

    public void m_77757_(File file) {
        if (this.toRemove) {
            file.delete();
        } else {
            try {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SophisticatedStorageInMotion.LOGGER.error("Failed to create directories for moving storage data", (Throwable)e);
            }
            super.m_77757_(file);
        }
    }

    public void setContents(UUID storageUuid, CompoundTag contents) {
        for (String key : contents.m_128431_()) {
            this.movingStorageContents.m_128365_(key, contents.m_128423_(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageUuid);
        }
        this.m_77762_();
    }

    public CompoundTag getContents() {
        return this.movingStorageContents;
    }

    public void setContents(CompoundTag contents) {
        this.movingStorageContents = contents;
        this.m_77762_();
    }

    public void markChanged() {
        this.m_77762_();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID backpackUuid) {
        return this.updatedStorageSettingsFlags.remove(backpackUuid);
    }
}

