/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;

public class StorageMinecart
extends MinecartChest
implements IMovingStorageEntity {
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.m_135353_(StorageMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
    static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.m_135353_(StorageMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final EntityStorageHolder<StorageMinecart> entityStorageHolder;
    private final LazyOptional<?> itemHandler = LazyOptional.of(() -> this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput());

    public StorageMinecart(EntityType<StorageMinecart> entityType, Level level) {
        super(entityType, level);
        this.entityStorageHolder = new EntityStorageHolder<StorageMinecart>(this);
    }

    public StorageMinecart(Level level) {
        this((EntityType<StorageMinecart>)((EntityType)ModEntities.STORAGE_MINECART.get()), level);
    }

    public StorageMinecart(Level level, double x, double y, double z) {
        this(level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STORAGE_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_CUSTOM_NAME, Optional.empty());
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.f_19804_.m_135381_(DATA_STORAGE_ITEM, (Object)storageItem.m_41777_());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.getStorageHolder().hurt(source, amount, (x$0, x$1) -> super.m_6469_(x$0, x$1));
    }

    public void m_7617_(DamageSource source) {
        this.m_6074_();
        this.getStorageHolder().onDestroy();
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        ItemStack drop = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        drop.m_41784_().m_128365_("storageItem", (Tag)storageItem.m_41739_(new CompoundTag()));
        return drop;
    }

    public ItemStack m_142340_() {
        ItemStack result = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        ItemStack storageItemCopy = this.getStorageItem().m_41777_();
        NBTHelper.removeTag((ItemStack)storageItemCopy, (String)"uuid");
        result.m_41784_().m_128365_("storageItem", (Tag)storageItemCopy.m_41739_(new CompoundTag()));
        return result;
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("storageHolder", (Tag)this.entityStorageHolder.saveData());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.entityStorageHolder.readData(tag.m_128469_("storageHolder"));
    }

    public void m_8119_() {
        super.m_8119_();
        this.entityStorageHolder.tick((Entity)this);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == DATA_STORAGE_ITEM && this.m_9236_().m_5776_()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    public void m_6593_(@Nullable Component customName) {
        this.f_19804_.m_135381_(DATA_CUSTOM_NAME, Optional.ofNullable(customName));
    }

    public Component m_7770_() {
        return (Component)((Optional)this.f_19804_.m_135370_(DATA_CUSTOM_NAME)).orElse(Component.m_237119_());
    }

    protected Component m_5677_() {
        return Component.m_237110_((String)StorageInMotionTranslationHelper.INSTANCE.translEntity("storage_minecart"), (Object[])new Object[]{this.getStorageItem().m_41786_()});
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getStorageHolder().openContainerMenu((Player)serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return this.getStorageHolder().createMenu(id, playerInventory.f_35978_);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.m_142467_(pReason);
        this.invalidateCaps();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public int m_6643_() {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getSlots();
    }

    public NonNullList<ItemStack> m_213659_() {
        return NonNullList.m_122779_();
    }

    public void m_219943_(CompoundTag tag) {
        if (this.m_214142_() != null) {
            tag.m_128359_("LootTable", this.m_214142_().toString());
            if (this.m_213803_() != 0L) {
                tag.m_128356_("LootTableSeed", this.m_213803_());
            }
        }
    }

    public void m_219934_(CompoundTag tag) {
        this.m_213775_();
        if (tag.m_128425_("LootTable", 8)) {
            this.m_214199_(ResourceLocation.m_135820_((String)tag.m_128461_("LootTable")));
            this.m_214065_(tag.m_128454_("LootTableSeed"));
        }
    }

    public void m_219927_(DamageSource damageSource, Level level, Entity p_entity) {
    }

    public void m_219953_() {
        this.m_219949_(null);
        InventoryHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            inventoryHandler.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    public ItemStack m_219945_(int slot) {
        ITrackedContentsItemHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput();
        return inventoryHandler.extractItem(slot, inventoryHandler.getStackInSlot(slot).m_41613_(), false);
    }

    public ItemStack m_219947_(int slot) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getStackInSlot(slot);
    }

    public ItemStack m_219936_(int slot, int amount) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().extractItem(slot, amount, false);
    }

    public void m_219940_(int slot, ItemStack stack) {
        this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().setStackInSlot(slot, stack);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().isItemValid(pIndex, pStack);
    }

    public SlotAccess m_219951_(int index) {
        return SlotAccess.f_147290_;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

