/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItemClient;

public abstract class MovingStorageItem
extends ItemBase
implements IStashStorageItem {
    public MovingStorageItem(Item.Properties properties) {
        super(properties);
    }

    public static void setStorageItem(ItemStack movingStorageItem, ItemStack storageItem) {
        NBTHelper.setCompoundNBT((ItemStack)movingStorageItem, (String)"storageItem", (CompoundTag)storageItem.serializeNBT());
    }

    public static Optional<Item> getStorageItemType(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).map(ItemStack::m_41720_);
    }

    public static Optional<WoodType> getStorageItemWoodType(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).flatMap(WoodStorageBlockItem::getWoodType);
    }

    public static Optional<Integer> getStorageItemMainColor(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).flatMap(StorageBlockItem::getMainColorFromStack);
    }

    public static Optional<Integer> getStorageItemAccentColor(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).flatMap(StorageBlockItem::getAccentColorFromStack);
    }

    public static boolean isStorageItemFlatTopBarrel(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).map(BarrelBlockItem::isFlatTop).orElse(false);
    }

    public static ItemStack getStorageItem(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).orElse(ItemStack.f_41583_);
    }

    public abstract ItemStack getUncraftRemainingItem(ItemStack var1);

    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Config.COMMON.enabledItems.isItemEnabled((Item)this)) {
            List<ItemStack> movingStorages = this.getBaseMovingStorageItems();
            movingStorages.forEach(movingStorage -> {
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get()), (WoodType)WoodType.f_61831_)));
                ItemStack limitedIStack = new ItemStack((ItemLike)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get());
                Item patt4645$temp = limitedIStack.m_41720_();
                if (patt4645$temp instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt4645$temp;
                    tintableBlockItem.setMainColor(limitedIStack, ColorHelper.getColor((float[])DyeColor.YELLOW.m_41068_()));
                    tintableBlockItem.setAccentColor(limitedIStack, ColorHelper.getColor((float[])DyeColor.LIME.m_41068_()));
                }
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), limitedIStack));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (WoodType)WoodType.f_61832_)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_IRON_BARREL_3.get()), (WoodType)WoodType.f_61833_)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_DIAMOND_BARREL_4.get()), (WoodType)WoodType.f_61836_)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.NETHERITE_CHEST_ITEM.get()), (WoodType)WoodType.f_244200_)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.m_41777_(), new ItemStack((ItemLike)ModBlocks.IRON_SHULKER_BOX_ITEM.get())));
            });
        }
    }

    public List<ItemStack> getBaseMovingStorageItems() {
        return List.of(new ItemStack((ItemLike)this));
    }

    public static ItemStack createWithStorage(ItemStack movingStorage, ItemStack storageStack) {
        MovingStorageItem.setStorageItem(movingStorage, storageStack);
        return movingStorage;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltip, tooltipFlag);
        if (tooltipFlag.m_7050_() && MovingStorageWrapper.hasContentsUuid((ItemStack)stack)) {
            MovingStorageItem.getMovingStorageWrapper(stack).getContentsUuid().ifPresent(uuid -> tooltip.add((Component)Component.m_237113_((String)("UUID: " + String.valueOf(uuid))).m_130940_(ChatFormatting.DARK_GRAY)));
        }
        if (!Screen.m_96638_() && MovingStorageWrapper.hasContentsUuid((ItemStack)stack)) {
            tooltip.add((Component)Component.m_237110_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Component m_7626_(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).map(storageItem -> Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{storageItem.m_41786_()})).orElse(super.m_7626_(stack));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (FMLEnvironment.dist.isClient()) {
            return Optional.ofNullable(MovingStorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new MovingStorageContentsTooltip(stack));
    }

    public IStashStorageItem.StashResult getItemStashable(ItemStack storageStack, ItemStack stack) {
        if (MovingStorageItem.getStorageItemType(storageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false).booleanValue()) {
            MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(storageStack);
            if (wrapper.getInventoryForUpgradeProcessing().insertItem(stack, true).m_41613_() == stack.m_41613_()) {
                return IStashStorageItem.StashResult.NO_SPACE;
            }
            if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.m_41720_()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
                return IStashStorageItem.StashResult.MATCH_AND_SPACE;
            }
            return IStashStorageItem.StashResult.SPACE;
        }
        return IStashStorageItem.StashResult.NO_SPACE;
    }

    public static MovingStorageWrapper getMovingStorageWrapper(ItemStack movingStorageStack) {
        ItemStack storageItem = MovingStorageItem.getStorageItem(movingStorageStack);
        return MovingStorageWrapper.fromStack((ItemStack)storageItem, () -> {}, () -> MovingStorageItem.setStorageItem(movingStorageStack, storageItem), MovingStorageData::get, () -> NBTHelper.getBoolean((ItemStack)movingStorageStack, (String)"locked").orElse(false), locked -> movingStorageStack.m_41784_().m_128379_("locked", locked.booleanValue()), upgrade -> true);
    }

    public ItemStack stash(ItemStack movingStorageStack, ItemStack stack, boolean simulate) {
        MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(movingStorageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        return wrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.m_41613_() > 1 || !slot.m_8010_(player) || slot.m_7993_().m_41619_() || action != ClickAction.SECONDARY || !this.isShulkerBoxMovingStorage(stack)) {
            return super.m_142207_(stack, slot, action, player);
        }
        ItemStack stackToStash = slot.m_7993_();
        ItemStack stashResult = this.stash(stack, stackToStash, true);
        if (stashResult.m_41613_() != stackToStash.m_41613_()) {
            int countToTake = stackToStash.m_41613_() - stashResult.m_41613_();
            ItemStack takeResult = slot.m_150647_(countToTake, countToTake, player);
            this.stash(stack, takeResult, false);
            return true;
        }
        return super.m_142207_(stack, slot, action, player);
    }

    private boolean isShulkerBoxMovingStorage(ItemStack movingStorageStack) {
        return MovingStorageItem.getStorageItemType(movingStorageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false);
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.m_41613_() > 1 || !slot.m_5857_(stack) || action != ClickAction.SECONDARY || !this.isShulkerBoxMovingStorage(stack)) {
            return super.m_142305_(stack, otherStack, slot, action, player, carriedAccess);
        }
        ItemStack result = this.stash(stack, otherStack, false);
        if (result.m_41613_() != otherStack.m_41613_()) {
            carriedAccess.m_142104_(result);
            slot.m_5852_(stack);
            return true;
        }
        return super.m_142305_(stack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(Player player) {
        return player.m_9236_().m_5776_() && player.f_36096_ instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    static {
        DecorationTableBlockEntity.registerItemDecorator(stack -> stack.m_41720_() instanceof MovingStorageItem, (DecorationTableBlockEntity.IItemDecorator)new DecorationTableBlockEntity.IItemDecorator(){

            public boolean supportsMaterials(ItemStack input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsMaterials(storageItem);
            }

            public boolean supportsTints(ItemStack input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTints(storageItem);
            }

            public boolean supportsTopInnerTrim(ItemStack input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTopInnerTrim(storageItem);
            }

            public ItemStack decorateWithMaterials(ItemStack input, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
                ItemStack storageItem = MovingStorageItem.getStorageItem(input);
                ItemStack storageResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithMaterials(storageItem, materialsToApply);
                if (storageResult.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                ItemStack result = input.m_41777_();
                MovingStorageItem.setStorageItem(result, storageResult);
                return result;
            }

            public DecorationTableBlockEntity.TintDecorationResult decorateWithTints(ItemStack input, int mainColorToSet, int accentColorToSet) {
                ItemStack storageItem = MovingStorageItem.getStorageItem(input);
                DecorationTableBlockEntity.TintDecorationResult tintResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithTints(storageItem, mainColorToSet, accentColorToSet);
                if (tintResult.result().m_41619_()) {
                    return DecorationTableBlockEntity.TintDecorationResult.EMPTY;
                }
                ItemStack result = input.m_41777_();
                MovingStorageItem.setStorageItem(result, tintResult.result());
                return new DecorationTableBlockEntity.TintDecorationResult(result, tintResult.requiredDyeParts());
            }
        });
    }

    public record MovingStorageContentsTooltip(ItemStack movingStorage) implements TooltipComponent
    {
        public ItemStack getMovingStorage() {
            return this.movingStorage;
        }
    }
}

