/*
 * Decompiled with CFR 0.152.
 */
package com.toshicz.noopportmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.toshicz.noopportmod.config.NoOPPortCommonConfigs;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> p_139009_) {
        if (((Boolean)NoOPPortCommonConfigs.TELEPORT_ON_COORDINATES.get()).booleanValue()) {
            p_139009_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"port").requires(p_139039_ -> p_139039_.m_6761_(0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(p_139051_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139051_.getSource(), Collections.singleton(((CommandSourceStack)p_139051_.getSource()).m_81374_()), ((CommandSourceStack)p_139051_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139051_, (String)"location"), (Coordinates)WorldCoordinates.m_120898_(), null))).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(p_139045_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139045_.getSource(), Collections.singleton(((CommandSourceStack)p_139045_.getSource()).m_81374_()), ((CommandSourceStack)p_139045_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139045_, (String)"location"), RotationArgument.m_120482_((CommandContext)p_139045_, (String)"rotation"), null)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"facing").then(Commands.m_82127_((String)"entity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"facingEntity", (ArgumentType)EntityArgument.m_91449_()).executes(p_139043_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139043_.getSource(), Collections.singleton(((CommandSourceStack)p_139043_.getSource()).m_81374_()), ((CommandSourceStack)p_139043_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139043_, (String)"location"), null, new LookAt(EntityArgument.m_91452_((CommandContext)p_139043_, (String)"facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.m_82129_((String)"facingAnchor", (ArgumentType)EntityAnchorArgument.m_90350_()).executes(p_139041_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139041_.getSource(), Collections.singleton(((CommandSourceStack)p_139041_.getSource()).m_81374_()), ((CommandSourceStack)p_139041_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139041_, (String)"location"), null, new LookAt(EntityArgument.m_91452_((CommandContext)p_139041_, (String)"facingEntity"), EntityAnchorArgument.m_90353_((CommandContext)p_139041_, (String)"facingAnchor")))))))).then(Commands.m_82129_((String)"facingLocation", (ArgumentType)Vec3Argument.m_120841_()).executes(p_139037_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139037_.getSource(), Collections.singleton(((CommandSourceStack)p_139037_.getSource()).m_81374_()), ((CommandSourceStack)p_139037_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139037_, (String)"location"), null, new LookAt(Vec3Argument.m_120844_((CommandContext)p_139037_, (String)"facingLocation"))))))));
        }
        if (((Boolean)NoOPPortCommonConfigs.TELEPORT_ON_PLAYERS.get()).booleanValue()) {
            p_139009_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"port").requires(p_139039_ -> p_139039_.m_6761_(0))).then(Commands.m_82129_((String)"destination", (ArgumentType)EntityArgument.m_91449_()).executes(p_139049_ -> TeleportCommand.teleportToEntity((CommandSourceStack)p_139049_.getSource(), Collections.singleton(((CommandSourceStack)p_139049_.getSource()).m_81374_()), EntityArgument.m_91452_((CommandContext)p_139049_, (String)"destination")))));
        }
        if (((Boolean)NoOPPortCommonConfigs.TELEPORT_OTHER_PLAYERS.get()).booleanValue()) {
            if (((Boolean)NoOPPortCommonConfigs.TELEPORT_ON_COORDINATES.get()).booleanValue()) {
                p_139009_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"port").requires(p_139039_ -> p_139039_.m_6761_(0))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(p_139047_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139047_.getSource(), EntityArgument.m_91461_((CommandContext)p_139047_, (String)"targets"), ((CommandSourceStack)p_139047_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139047_, (String)"location"), null, null))).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(p_139045_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139045_.getSource(), EntityArgument.m_91461_((CommandContext)p_139045_, (String)"targets"), ((CommandSourceStack)p_139045_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139045_, (String)"location"), RotationArgument.m_120482_((CommandContext)p_139045_, (String)"rotation"), null)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"facing").then(Commands.m_82127_((String)"entity").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"facingEntity", (ArgumentType)EntityArgument.m_91449_()).executes(p_139043_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139043_.getSource(), EntityArgument.m_91461_((CommandContext)p_139043_, (String)"targets"), ((CommandSourceStack)p_139043_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139043_, (String)"location"), null, new LookAt(EntityArgument.m_91452_((CommandContext)p_139043_, (String)"facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.m_82129_((String)"facingAnchor", (ArgumentType)EntityAnchorArgument.m_90350_()).executes(p_139041_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139041_.getSource(), EntityArgument.m_91461_((CommandContext)p_139041_, (String)"targets"), ((CommandSourceStack)p_139041_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139041_, (String)"location"), null, new LookAt(EntityArgument.m_91452_((CommandContext)p_139041_, (String)"facingEntity"), EntityAnchorArgument.m_90353_((CommandContext)p_139041_, (String)"facingAnchor")))))))).then(Commands.m_82129_((String)"facingLocation", (ArgumentType)Vec3Argument.m_120841_()).executes(p_139037_ -> TeleportCommand.teleportToPos((CommandSourceStack)p_139037_.getSource(), EntityArgument.m_91461_((CommandContext)p_139037_, (String)"targets"), ((CommandSourceStack)p_139037_.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)p_139037_, (String)"location"), null, new LookAt(Vec3Argument.m_120844_((CommandContext)p_139037_, (String)"facingLocation")))))))));
            }
            if (((Boolean)NoOPPortCommonConfigs.TELEPORT_ON_PLAYERS.get()).booleanValue()) {
                p_139009_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"port").requires(p_139039_ -> p_139039_.m_6761_(0))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"destination", (ArgumentType)EntityArgument.m_91449_()).executes(p_139011_ -> TeleportCommand.teleportToEntity((CommandSourceStack)p_139011_.getSource(), EntityArgument.m_91461_((CommandContext)p_139011_, (String)"targets"), EntityArgument.m_91452_((CommandContext)p_139011_, (String)"destination"))))));
            }
        }
    }

    private static int teleportToEntity(CommandSourceStack p_139033_, Collection<? extends Entity> p_139034_, Entity p_139035_) throws CommandSyntaxException {
        for (Entity entity : p_139034_) {
            TeleportCommand.performTeleport(p_139033_, entity, (ServerLevel)p_139035_.m_9236_(), p_139035_.m_20185_(), p_139035_.m_20186_(), p_139035_.m_20189_(), EnumSet.noneOf(RelativeMovement.class), p_139035_.m_146908_(), p_139035_.m_146909_(), null);
        }
        if (p_139034_.size() == 1) {
            p_139033_.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.entity.single", (Object[])new Object[]{((Entity)p_139034_.iterator().next()).m_5446_(), p_139035_.m_5446_()}), true);
        } else {
            p_139033_.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.entity.multiple", (Object[])new Object[]{p_139034_.size(), p_139035_.m_5446_()}), true);
        }
        return p_139034_.size();
    }

    private static int teleportToPos(CommandSourceStack p_139026_, Collection<? extends Entity> p_139027_, ServerLevel p_139028_, Coordinates p_139029_, @Nullable Coordinates p_139030_, @Nullable LookAt p_139031_) throws CommandSyntaxException {
        Vec3 vec3 = p_139029_.m_6955_(p_139026_);
        Vec2 vec2 = p_139030_ == null ? null : p_139030_.m_6970_(p_139026_);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (p_139029_.m_6888_()) {
            set.add(RelativeMovement.X);
        }
        if (p_139029_.m_6892_()) {
            set.add(RelativeMovement.Y);
        }
        if (p_139029_.m_6900_()) {
            set.add(RelativeMovement.Z);
        }
        if (p_139030_ == null) {
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
        } else {
            if (p_139030_.m_6888_()) {
                set.add(RelativeMovement.X_ROT);
            }
            if (p_139030_.m_6892_()) {
                set.add(RelativeMovement.Y_ROT);
            }
        }
        for (Entity entity : p_139027_) {
            if (p_139030_ == null) {
                TeleportCommand.performTeleport(p_139026_, entity, p_139028_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, set, entity.m_146908_(), entity.m_146909_(), p_139031_);
                continue;
            }
            TeleportCommand.performTeleport(p_139026_, entity, p_139028_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, set, vec2.f_82471_, vec2.f_82470_, p_139031_);
        }
        if (p_139027_.size() == 1) {
            p_139026_.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)p_139027_.iterator().next()).m_5446_(), TeleportCommand.formatDouble(vec3.f_82479_), TeleportCommand.formatDouble(vec3.f_82480_), TeleportCommand.formatDouble(vec3.f_82481_)}), true);
        } else {
            p_139026_.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{p_139027_.size(), TeleportCommand.formatDouble(vec3.f_82479_), TeleportCommand.formatDouble(vec3.f_82480_), TeleportCommand.formatDouble(vec3.f_82481_)}), true);
        }
        return p_139027_.size();
    }

    private static String formatDouble(double p_142776_) {
        return String.format(Locale.ROOT, "%f", p_142776_);
    }

    private static void performTeleport(CommandSourceStack p_139015_, Entity p_139016_, ServerLevel p_139017_, double p_139018_, double p_139019_, double p_139020_, Set<RelativeMovement> p_139021_, float p_139022_, float p_139023_, @Nullable LookAt p_139024_) throws CommandSyntaxException {
        float f1;
        EntityTeleportEvent.TeleportCommand event = ForgeEventFactory.onEntityTeleportCommand((Entity)p_139016_, (double)p_139018_, (double)p_139019_, (double)p_139020_);
        if (event.isCanceled()) {
            return;
        }
        p_139018_ = event.getTargetX();
        BlockPos blockpos = BlockPos.m_274561_((double)p_139018_, (double)(p_139019_ = event.getTargetY()), (double)(p_139020_ = event.getTargetZ()));
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        float f = Mth.m_14177_((float)p_139022_);
        if (p_139016_.m_264318_(p_139017_, p_139018_, p_139019_, p_139020_, p_139021_, f, f1 = Mth.m_14177_((float)p_139023_))) {
            LivingEntity livingentity;
            if (p_139024_ != null) {
                p_139024_.perform(p_139015_, p_139016_);
            }
            if (!(p_139016_ instanceof LivingEntity) || !(livingentity = (LivingEntity)p_139016_).m_21255_()) {
                p_139016_.m_20256_(p_139016_.m_20184_().m_82542_(1.0, 0.0, 1.0));
                p_139016_.m_6853_(true);
            }
            if (p_139016_ instanceof PathfinderMob) {
                PathfinderMob pathfindermob = (PathfinderMob)p_139016_;
                pathfindermob.m_21573_().m_26573_();
            }
        }
    }

    static class LookAt {
        private final Vec3 position;
        private final Entity entity;
        private final EntityAnchorArgument.Anchor anchor;

        public LookAt(Entity p_139056_, EntityAnchorArgument.Anchor p_139057_) {
            this.entity = p_139056_;
            this.anchor = p_139057_;
            this.position = p_139057_.m_90377_(p_139056_);
        }

        public LookAt(Vec3 p_139059_) {
            this.entity = null;
            this.position = p_139059_;
            this.anchor = null;
        }

        public void perform(CommandSourceStack p_139061_, Entity p_139062_) {
            if (this.entity != null) {
                if (p_139062_ instanceof ServerPlayer) {
                    ((ServerPlayer)p_139062_).m_9107_(p_139061_.m_81378_(), this.entity, this.anchor);
                } else {
                    p_139062_.m_7618_(p_139061_.m_81378_(), this.position);
                }
            } else {
                p_139062_.m_7618_(p_139061_.m_81378_(), this.position);
            }
        }
    }
}

