/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

public abstract class AdsorptionRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, FluidStack> {
    private final ItemStackIngredient itemInput;
    private final FluidStackIngredient fluidInput;
    private final BoxedChemicalStack output;

    public AdsorptionRecipe(ResourceLocation id, ItemStackIngredient itemInput, FluidStackIngredient fluidInput, ChemicalStack<?> output) {
        super(id);
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = BoxedChemicalStack.box((ChemicalStack)output.copy());
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public BoxedChemicalStack getOutput(ItemStack inputItem, FluidStack inputGas) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, FluidStack fluidStack) {
        return this.itemInput.test((Object)itemStack) && this.fluidInput.test((Object)fluidStack);
    }

    public List<BoxedChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public boolean m_142505_() {
        return this.itemInput.hasNoMatchingInstances() || this.fluidInput.hasNoMatchingInstances();
    }

    public void write(FriendlyByteBuf buffer) {
        this.itemInput.write(buffer);
        this.fluidInput.write(buffer);
        buffer.m_130068_((Enum)this.output.getChemicalType());
        this.output.getChemicalStack().writeToPacket(buffer);
    }
}

