/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.api.recipes.cache;

import com.fxd927.mekanismelements.api.recipes.ChemicalDemolitionRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChemicalDemolitionCachedRecipe
extends CachedRecipe<ChemicalDemolitionRecipe> {
    private final IOutputHandler firstOutputHandler;
    private final IOutputHandler secondOutputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;
    private long gasUsageMultiplier;
    private ItemStack recipeItem = ItemStack.f_41583_;
    private GasStack recipeGas = GasStack.EMPTY;
    private ItemStack firstOutput = ItemStack.f_41583_;
    private ItemStack secondOutput = ItemStack.f_41583_;

    public ChemicalDemolitionCachedRecipe(ChemicalDemolitionRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<@NotNull GasStack> gasInputHandler, LongSupplier gasUsage, IOutputHandler firstOutputHandler, IOutputHandler secondOutputHandler) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasUsage = Objects.requireNonNull(gasUsage, "Gas usage cannot be null.");
        this.firstOutputHandler = Objects.requireNonNull(firstOutputHandler, "First Input handler cannot be null.");
        this.secondOutputHandler = Objects.requireNonNull(secondOutputHandler, "Second Input handler cannot be null.");
    }

    protected void setupVariableValues() {
        this.gasUsageMultiplier = Math.max(this.gasUsage.getAsLong(), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((ChemicalDemolitionRecipe)this.recipe).getItemInput());
            if (this.recipeItem.m_41619_()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((ChemicalDemolitionRecipe)this.recipe).getGasInput());
                if (this.recipeGas.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeGas.isEmpty() && tracker.shouldContinueChecking()) {
                    this.gasInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeGas, this.gasUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.firstOutput = ((ChemicalDemolitionRecipe)this.recipe).getFirstOutput(this.recipeItem, this.recipeGas);
                        this.secondOutput = ((ChemicalDemolitionRecipe)this.recipe).getSecondOutput(this.recipeItem, this.recipeGas);
                        this.firstOutputHandler.calculateOperationsCanSupport(tracker, (Object)this.firstOutput);
                        this.secondOutputHandler.calculateOperationsCanSupport(tracker, (Object)this.secondOutput);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        GasStack gasStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.m_41619_() && !(gasStack = (GasStack)this.gasInputHandler.getInput()).isEmpty() && ((ChemicalDemolitionRecipe)this.recipe).test(itemInput, gasStack)) {
            GasStack recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((ChemicalDemolitionRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.gasUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use((Object)this.recipeGas, (long)operations * this.gasUsageMultiplier);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeItem.m_41619_() || this.recipeGas.isEmpty() || this.firstOutput.m_41619_() || this.secondOutput.m_41619_())) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            if (this.gasUsageMultiplier > 0L) {
                this.gasInputHandler.use((Object)this.recipeGas, (long)operations * this.gasUsageMultiplier);
            }
            this.firstOutputHandler.handleOutput((Object)this.firstOutput, operations);
            this.secondOutputHandler.handleOutput((Object)this.secondOutput, operations);
        }
    }
}

