/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common;

import com.fxd927.mekanismelements.common.MSReloadListener;
import com.fxd927.mekanismelements.common.config.MSConfig;
import com.fxd927.mekanismelements.common.recipe.MSRecipeType;
import com.fxd927.mekanismelements.common.registries.MSBlocks;
import com.fxd927.mekanismelements.common.registries.MSContainerTypes;
import com.fxd927.mekanismelements.common.registries.MSCreativeTab;
import com.fxd927.mekanismelements.common.registries.MSEffects;
import com.fxd927.mekanismelements.common.registries.MSFluids;
import com.fxd927.mekanismelements.common.registries.MSGases;
import com.fxd927.mekanismelements.common.registries.MSItems;
import com.fxd927.mekanismelements.common.registries.MSRecipeSerializers;
import com.fxd927.mekanismelements.common.registries.MSSounds;
import com.fxd927.mekanismelements.common.registries.MSTileEntityTypes;
import mekanism.api.MekanismAPI;
import mekanism.common.lib.Version;
import mekanism.common.tile.component.TileComponentChunkLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismelements")
public class MekanismElements {
    public static final String MODID = "mekanismelements";
    public final Version versionNumber;
    private MSReloadListener recipeCacheManager;

    public MekanismElements() {
        this(FMLJavaModLoadingContext.get());
    }

    public MekanismElements(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        IEventBus modEventBus = context.getModEventBus();
        MSConfig.registerConfigs(ModLoadingContext.get());
        modEventBus.addListener(this::commonSetup);
        MSCreativeTab.CREATIVE_TABS.register(modEventBus);
        MSFluids.FLUIDS.register(modEventBus);
        MSGases.GASES.register(modEventBus);
        MSItems.ITEMS.register(modEventBus);
        MSItems.BUILDING_ITEMS.register(modEventBus);
        MSBlocks.BLOCKS.register(modEventBus);
        MSBlocks.BUILDING_BLOCKS.register(modEventBus);
        MSContainerTypes.CONTAINER_TYPES.register(modEventBus);
        MSTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MSEffects.MOB_EFFECTS.register(modEventBus);
        MSRecipeType.RECIPE_TYPES.register(modEventBus);
        MSRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        MSSounds.SOUND_EVENTS.register(modEventBus);
        MSGases.Coolants.init();
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void setRecipeCacheManager(MSReloadListener manager) {
        if (this.recipeCacheManager == null) {
            this.recipeCacheManager = manager;
        } else {
            MekanismAPI.logger.warn("Recipe cache manager has already been set.");
        }
    }

    public MSReloadListener getRecipeCacheManager() {
        return this.recipeCacheManager;
    }

    private void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.getRecipeCacheManager());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MekanismAPI.logger.info("Version {} initializing...", (Object)this.versionNumber);
        this.setRecipeCacheManager(new MSReloadListener());
        event.enqueueWork(() -> {
            ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (ForgeChunkManager.LoadingValidationCallback)TileComponentChunkLoader.ChunkValidationCallback.INSTANCE);
            MSFluids.FLUIDS.registerBucketDispenserBehavior();
        });
    }
}

