/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.recipe;

import com.fxd927.mekanismelements.api.recipes.AdsorptionRecipe;
import com.fxd927.mekanismelements.api.recipes.ChemicalDemolitionRecipe;
import com.fxd927.mekanismelements.api.recipes.RadiationIrradiatingRecipe;
import com.fxd927.mekanismelements.common.MekanismElements;
import com.fxd927.mekanismelements.common.recipe.IMSRecipeTypeProvider;
import com.fxd927.mekanismelements.common.recipe.lookup.cache.MSInputRecipeCache;
import com.fxd927.mekanismelements.common.registration.impl.MSRecipeTypeDeferredRegister;
import com.fxd927.mekanismelements.common.registration.impl.MSRecipeTypeRegistryObject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.client.MekanismClient;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSRecipeType<RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache>
implements RecipeType<RECIPE>,
IMSRecipeTypeProvider<RECIPE, INPUT_CACHE> {
    public static final MSRecipeTypeDeferredRegister RECIPE_TYPES = new MSRecipeTypeDeferredRegister("mekanismelements");
    public static final MSRecipeTypeRegistryObject<RadiationIrradiatingRecipe, MSInputRecipeCache.ItemChemical<Gas, GasStack, RadiationIrradiatingRecipe>> RADIATION_IRRADIATING = MSRecipeType.register("radiation_irradiating", recipeType -> new MSInputRecipeCache.ItemChemical((MSRecipeType<RadiationIrradiatingRecipe, ?>)recipeType, RadiationIrradiatingRecipe::getItemInput, RadiationIrradiatingRecipe::getGasInput));
    public static final MSRecipeTypeRegistryObject<AdsorptionRecipe, MSInputRecipeCache.ItemFluid<AdsorptionRecipe>> ADSORPTION = MSRecipeType.register("adsorption", recipeType -> new MSInputRecipeCache.ItemFluid<AdsorptionRecipe>((MSRecipeType<AdsorptionRecipe, ?>)recipeType, AdsorptionRecipe::getItemInput, AdsorptionRecipe::getFluidInput));
    public static final MSRecipeTypeRegistryObject<FluidToFluidRecipe, MSInputRecipeCache.SingleFluid<FluidToFluidRecipe>> ADVANCED_EVAPORATING = MSRecipeType.register("evaporating", recipeType -> new MSInputRecipeCache.SingleFluid<FluidToFluidRecipe>((MSRecipeType<FluidToFluidRecipe, ?>)recipeType, FluidToFluidRecipe::getInput));
    public static final MSRecipeTypeRegistryObject<ChemicalDemolitionRecipe, MSInputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDemolitionRecipe>> CHEMICAL_DEMOLITION = MSRecipeType.register("chemical_demolition", recipeType -> new MSInputRecipeCache.ItemChemical((MSRecipeType<ChemicalDemolitionRecipe, ?>)recipeType, ChemicalDemolitionRecipe::getItemInput, ChemicalDemolitionRecipe::getGasInput));
    private List<RECIPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    private final INPUT_CACHE inputCache;

    public static <RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> MSRecipeTypeRegistryObject<RECIPE, INPUT_CACHE> register(String name, Function<MSRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        return RECIPE_TYPES.register(name, () -> new MSRecipeType(name, inputCacheCreator));
    }

    public static void clearCache() {
        for (IMSRecipeTypeProvider<?, ?> recipeTypeProvider : RECIPE_TYPES.getAllRecipeTypes()) {
            recipeTypeProvider.getMSRecipeType().clearCaches();
        }
    }

    private MSRecipeType(String name, Function<MSRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        this.registryName = MekanismElements.rl(name);
        this.inputCache = (IInputRecipeCache)inputCacheCreator.apply(this);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public MSRecipeType<RECIPE, INPUT_CACHE> getMSRecipeType() {
        return this;
    }

    private void clearCaches() {
        this.cachedRecipes = Collections.emptyList();
        this.inputCache.clear();
    }

    @Override
    public INPUT_CACHE getInputCache() {
        return this.inputCache;
    }

    @Override
    @NotNull
    public List<RECIPE> getRecipes(@Nullable Level world) {
        if (world == null && (world = FMLEnvironment.dist.isClient() ? MekanismClient.tryGetClientWorld() : ServerLifecycleHooks.getCurrentServer().m_129783_()) == null) {
            return Collections.emptyList();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            List recipes = recipeManager.m_44013_((RecipeType)this);
            this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
        }
        return this.cachedRecipes;
    }

    public static <C extends Container, RECIPE_TYPE extends Recipe<C>> Optional<RECIPE_TYPE> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, C inventory, Level level) {
        return level.m_7465_().m_44015_(recipeType, inventory, level).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }

    public static Optional<? extends Recipe<?>> byKey(Level level, ResourceLocation id) {
        return level.m_7465_().m_44043_(id).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }
}

