/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.recipe.lookup.monitor;

import com.fxd927.mekanismelements.common.recipe.lookup.IMSRecipeLookupHandler;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ICachedRecipeHolder;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToItemStackCachedRecipe;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSRecipeCacheLookupMonitor<RECIPE extends MekanismRecipe>
implements ICachedRecipeHolder<RECIPE>,
IContentsListener {
    private final IMSRecipeLookupHandler<RECIPE> handler;
    protected final int cacheIndex;
    protected CachedRecipe<RECIPE> cachedRecipe;
    protected boolean hasNoRecipe;

    public MSRecipeCacheLookupMonitor(IMSRecipeLookupHandler<RECIPE> handler) {
        this(handler, 0);
    }

    public MSRecipeCacheLookupMonitor(IMSRecipeLookupHandler<RECIPE> handler, int cacheIndex) {
        this.handler = handler;
        this.cacheIndex = cacheIndex;
    }

    protected boolean cachedIndexMatches(int cacheIndex) {
        return this.cacheIndex == cacheIndex;
    }

    public final void onContentsChanged() {
        this.handler.onContentsChanged();
        this.onChange();
    }

    public void onChange() {
        this.hasNoRecipe = false;
    }

    public FloatingLong updateAndProcess(IEnergyContainer energyContainer) {
        FloatingLong prev = energyContainer.getEnergy().copy();
        if (this.updateAndProcess()) {
            return prev.minusEqual(energyContainer.getEnergy());
        }
        return FloatingLong.ZERO;
    }

    public boolean updateAndProcess() {
        CachedRecipe<RECIPE> oldCache = this.cachedRecipe;
        this.cachedRecipe = this.getUpdatedCache(this.cacheIndex);
        if (this.cachedRecipe != oldCache) {
            this.handler.onCachedRecipeChanged(this.cachedRecipe, this.cacheIndex);
        }
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
            return true;
        }
        return false;
    }

    public void loadSavedData(@NotNull CachedRecipe<RECIPE> cached, int cacheIndex) {
        if (this.cachedIndexMatches(cacheIndex)) {
            super.loadSavedData(cached, cacheIndex);
            if (cached instanceof ItemStackConstantChemicalToItemStackCachedRecipe) {
                ItemStackConstantChemicalToItemStackCachedRecipe c = (ItemStackConstantChemicalToItemStackCachedRecipe)cached;
                IMSRecipeLookupHandler<RECIPE> iMSRecipeLookupHandler = this.handler;
                if (iMSRecipeLookupHandler instanceof IRecipeLookupHandler.ConstantUsageRecipeLookupHandler) {
                    IRecipeLookupHandler.ConstantUsageRecipeLookupHandler handler = (IRecipeLookupHandler.ConstantUsageRecipeLookupHandler)iMSRecipeLookupHandler;
                    c.loadSavedUsageSoFar(handler.getSavedUsedSoFar(cacheIndex));
                }
            }
        }
    }

    public int getSavedOperatingTicks(int cacheIndex) {
        return this.cachedIndexMatches(cacheIndex) ? this.handler.getSavedOperatingTicks(cacheIndex) : super.getSavedOperatingTicks(cacheIndex);
    }

    @Nullable
    public CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.cachedIndexMatches(cacheIndex) ? this.cachedRecipe : null;
    }

    @Nullable
    public RECIPE getRecipe(int cacheIndex) {
        return this.cachedIndexMatches(cacheIndex) ? (RECIPE)this.handler.getRecipe(cacheIndex) : null;
    }

    @Nullable
    public CachedRecipe<RECIPE> createNewCachedRecipe(@NotNull RECIPE recipe, int cacheIndex) {
        return this.cachedIndexMatches(cacheIndex) ? this.handler.createNewCachedRecipe(recipe, cacheIndex) : null;
    }

    public boolean invalidateCache() {
        return CommonWorldTickHandler.flushTagAndRecipeCaches;
    }

    public void setHasNoRecipe(int cacheIndex) {
        if (this.cachedIndexMatches(cacheIndex)) {
            this.hasNoRecipe = true;
        }
    }

    public boolean hasNoRecipe(int cacheIndex) {
        return this.cachedIndexMatches(cacheIndex) ? this.hasNoRecipe : super.hasNoRecipe(cacheIndex);
    }
}

