/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.recipe.serializer;

import com.fxd927.mekanismelements.api.recipes.AdsorptionRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class AdsorptionRecipeSerializer<RECIPE extends AdsorptionRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public AdsorptionRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray fluidInput = GsonHelper.m_13885_((JsonObject)json, (String)"fluidInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"fluidInput");
        FluidStackIngredient fluidIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)fluidInput);
        ChemicalStack output = SerializerHelper.getBoxedChemicalStack((JsonObject)json, (String)"output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, fluidIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient itemInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            FluidStackIngredient fluidInput = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            ChemicalType chemicalType = (ChemicalType)buffer.m_130066_(ChemicalType.class);
            GasStack output = switch (chemicalType) {
                default -> throw new IncompatibleClassChangeError();
                case ChemicalType.GAS -> GasStack.readFromPacket((FriendlyByteBuf)buffer);
                case ChemicalType.INFUSION -> InfusionStack.readFromPacket((FriendlyByteBuf)buffer);
                case ChemicalType.PIGMENT -> PigmentStack.readFromPacket((FriendlyByteBuf)buffer);
                case ChemicalType.SLURRY -> SlurryStack.readFromPacket((FriendlyByteBuf)buffer);
            };
            return this.factory.create(recipeId, itemInput, fluidInput, (ChemicalStack<?>)output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((AdsorptionRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends AdsorptionRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, FluidStackIngredient var3, ChemicalStack<?> var4);
    }
}

