/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.recipe.serializer;

import com.fxd927.mekanismelements.api.recipes.ChemicalDemolitionRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemicalDemolitionRecipeSerializer<RECIPE extends ChemicalDemolitionRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ChemicalDemolitionRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray fluidInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
        ChemicalStackIngredient.GasStackIngredient fluidIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)fluidInput);
        ItemStack firstOutput = SerializerHelper.getItemStack((JsonObject)json, (String)"mainOutput");
        ItemStack secondOutput = SerializerHelper.getItemStack((JsonObject)json, (String)"secondaryOutput");
        if (firstOutput.m_41619_()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        if (secondOutput.m_41619_()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, fluidIngredient, firstOutput, secondOutput);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient itemInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ChemicalStackIngredient.GasStackIngredient fluidInput = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            ItemStack firstOutput = buffer.m_130267_();
            ItemStack secondOutput = buffer.m_130267_();
            return this.factory.create(recipeId, itemInput, fluidInput, firstOutput, secondOutput);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((ChemicalDemolitionRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ChemicalDemolitionRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ChemicalStackIngredient.GasStackIngredient var3, ItemStack var4, ItemStack var5);
    }
}

