/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.tile.machine;

import com.fxd927.mekanismelements.api.recipes.AdsorptionRecipe;
import com.fxd927.mekanismelements.api.recipes.cache.AdsorptionCachedRecipe;
import com.fxd927.mekanismelements.common.inventory.slot.MSInputInventorySlot;
import com.fxd927.mekanismelements.common.recipe.IMSRecipeTypeProvider;
import com.fxd927.mekanismelements.common.recipe.MSRecipeType;
import com.fxd927.mekanismelements.common.recipe.lookup.IMSDoubleRecipeLookupHandler;
import com.fxd927.mekanismelements.common.recipe.lookup.cache.MSInputRecipeCache;
import com.fxd927.mekanismelements.common.registries.MSBlocks;
import com.fxd927.mekanismelements.common.tile.prefab.MSTileEntityProgressMachine;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAdsorptionSeparator
extends MSTileEntityProgressMachine<AdsorptionRecipe>
implements IMSDoubleRecipeLookupHandler.ItemFluidRecipeLookupHandler<AdsorptionRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final long MAX_CHEMICAL = 10000L;
    public static final int BASE_TICKS_REQUIRED = 20;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGasInput", "getGasInputCapacity", "getGasInputNeeded", "getGasInputFilledPercentage"}, docPlaceholder="gas input tank")
    public BasicFluidTank inputTank;
    public MergedChemicalTank outputTank;
    public double injectUsage = 1.0;
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private MachineEnergyContainer<TileEntityAdsorptionSeparator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    MSInputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    MergedChemicalInventorySlot<MergedChemicalTank> outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityAdsorptionSeparator(BlockPos pos, BlockState state) {
        super((IBlockProvider)MSBlocks.ADSORPTION_SEPARATOR, pos, state, TRACKED_ERROR_TYPES, 20);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig((IInventorySlot)this.inputSlot, this.outputSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.inputTank);
        this.configComponent.setupOutputConfig(TransmissionType.GAS, (Object)this.outputTank.getGasTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupOutputConfig(TransmissionType.INFUSION, (Object)this.outputTank.getInfusionTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupOutputConfig(TransmissionType.PIGMENT, (Object)this.outputTank.getPigmentTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupOutputConfig(TransmissionType.SLURRY, (Object)this.outputTank.getSlurryTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY}).setCanTankEject(tank -> tank != this.inputTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.inputTank, (CachedRecipe.OperationTracker.RecipeError)TileEntityPressurizedReactionChamber.NOT_ENOUGH_FLUID_INPUT_ERROR);
        this.outputHandler = new BoxedChemicalOutputHandler(this.outputTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        IContentsListener saveOnlyListener = () -> ((TileEntityAdsorptionSeparator)this).markForSave();
        this.outputTank = MergedChemicalTank.create((IGasTank)((IGasTank)ChemicalTankBuilder.GAS.output(10000L, this.getListener(SubstanceType.GAS, saveOnlyListener))), (IInfusionTank)((IInfusionTank)ChemicalTankBuilder.INFUSION.output(10000L, this.getListener(SubstanceType.INFUSION, saveOnlyListener))), (IPigmentTank)((IPigmentTank)ChemicalTankBuilder.PIGMENT.output(10000L, this.getListener(SubstanceType.PIGMENT, saveOnlyListener))), (ISlurryTank)((ISlurryTank)ChemicalTankBuilder.SLURRY.output(10000L, this.getListener(SubstanceType.SLURRY, saveOnlyListener))));
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        this.inputTank = BasicFluidTank.create((int)10000, fluid -> this.containsRecipeB(this.inputTank.getFluid()), this::containsRecipeB, (IContentsListener)recipeCacheListener);
        builder.addTank((IExtendedFluidTank)this.inputTank);
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getGasTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getInfusionTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSidePigmentWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getPigmentTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideSlurryWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getSlurryTank());
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityAdsorptionSeparator)this).getDirection(), () -> ((TileEntityAdsorptionSeparator)this).getConfig());
        this.inputSlot = MSInputInventorySlot.at(item -> this.containsRecipeAB(item, this.inputTank.getFluid()), this::containsRecipeA, recipeCacheListener, 80, 22);
        ((MSInputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = MergedChemicalInventorySlot.drain((MergedChemicalTank)this.outputTank, (IContentsListener)listener, (int)152, (int)55);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAdsorptionSeparator)this).m_58904_(), (IContentsListener)listener, (int)152, (int)14);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.outputSlot.drainChemicalTanks();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    public IMSRecipeTypeProvider<AdsorptionRecipe, MSInputRecipeCache.ItemFluid<AdsorptionRecipe>> getMSRecipeType() {
        return MSRecipeType.ADSORPTION;
    }

    @Override
    @Nullable
    public AdsorptionRecipe getRecipe(int cacheIndex) {
        return (AdsorptionRecipe)this.findFirstRecipe(this.itemInputHandler, this.fluidInputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<AdsorptionRecipe> createNewCachedRecipe(@NotNull AdsorptionRecipe recipe, int cacheIndex) {
        return new AdsorptionCachedRecipe(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.fluidInputHandler, () -> StatUtils.inversePoisson((double)this.injectUsage), this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityAdsorptionSeparator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityAdsorptionSeparator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public MachineEnergyContainer<TileEntityAdsorptionSeparator> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    IChemicalTank<?, ?> getOutputTank() {
        MergedChemicalTank.Current current = this.outputTank.getCurrent();
        return this.outputTank.getTankFromCurrent(current == MergedChemicalTank.Current.EMPTY ? MergedChemicalTank.Current.GAS : current);
    }
}

