/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.tile.machine;

import com.fxd927.mekanismelements.common.registries.MSBlocks;
import com.fxd927.mekanismelements.common.registries.MSGases;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class TileEntityAirCompressor
extends TileEntityConfigurableMachine
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final GasStack COMPRESSED_AIR_STACK = new GasStack(MSGases.COMPRESSED_AIR, 200L);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGas", "getGasCapacity", "getGasNeeded", "getGasFilledPercentage"}, docPlaceholder="buffer tank")
    public IGasTank gasTank;
    public int ticksRequired = 19;
    public int operatingTicks;
    private MachineEnergyContainer<TileEntityAirCompressor> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="")
    GasInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="")
    GasInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="")
    private EnergyInventorySlot energySlot;

    public TileEntityAirCompressor(BlockPos pos, BlockState state) {
        super(MSBlocks.AIR_COMPRESSOR, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE, (Object)((Object)this)));
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIG_CARD, (Object)((Object)this)));
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig(List.of(this.inputSlot), List.of(this.outputSlot), (IInventorySlot)this.energySlot, true);
        this.configComponent.setupOutputConfig(TransmissionType.GAS, (Object)this.gasTank, new RelativeSide[0]);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this));
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.GAS}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this));
    }

    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((TileEntityAirCompressor)this).getDirection());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.output(10000L, listener);
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityAirCompressor)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    public boolean getActive() {
        return super.getActive();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityAirCompressor)this).getDirection());
        this.inputSlot = GasInventorySlot.drain((IGasTank)this.gasTank, (IContentsListener)listener, (int)28, (int)20);
        builder.addSlot((IInventorySlot)this.inputSlot);
        this.outputSlot = GasInventorySlot.drain((IGasTank)this.gasTank, (IContentsListener)listener, (int)28, (int)51);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAirCompressor)this).m_58904_(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        boolean isBlocked;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.outputSlot.drainTank();
        boolean isGeneratingCompressedAir = false;
        Direction frontDirection = RelativeSide.FRONT.getDirection(this.getDirection());
        BlockPos frontPos = this.m_58899_().m_121945_(frontDirection);
        boolean bl = isBlocked = !this.f_58857_.m_46859_(frontPos);
        if (!isBlocked && MekanismUtils.canFunction((TileEntityMekanism)this) && COMPRESSED_AIR_STACK.getAmount() <= this.gasTank.getNeeded() && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                this.gasTank.insert((ChemicalStack)COMPRESSED_AIR_STACK, Action.EXECUTE, AutomationType.INTERNAL);
                isGeneratingCompressedAir = true;
            }
        }
        if (!this.gasTank.isEmpty()) {
            ChemicalUtil.emit(Collections.singleton(Direction.UP), (IChemicalTank)this.gasTank, (BlockEntity)this, (long)(256L * (long)(1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED))));
        }
        this.setActive(isGeneratingCompressedAir);
    }

    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("progress", this.operatingTicks);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
    }

    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean canPulse() {
        return true;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)19);
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.gasTank.getStored(), (long)this.gasTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.GAS;
    }

    public List<Component> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public MachineEnergyContainer<TileEntityAirCompressor> getEnergyContainer() {
        return this.energyContainer;
    }
}

