/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.tile.machine;

import com.fxd927.mekanismelements.api.recipes.ChemicalDemolitionRecipe;
import com.fxd927.mekanismelements.api.recipes.cache.ChemicalDemolitionCachedRecipe;
import com.fxd927.mekanismelements.common.recipe.IMSRecipeTypeProvider;
import com.fxd927.mekanismelements.common.recipe.MSRecipeType;
import com.fxd927.mekanismelements.common.recipe.lookup.IMSDoubleRecipeLookupHandler;
import com.fxd927.mekanismelements.common.recipe.lookup.cache.MSInputRecipeCache;
import com.fxd927.mekanismelements.common.tile.prefab.MSTileEntityProgressMachine;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemicalDemolitionMachine
extends MSTileEntityProgressMachine<ChemicalDemolitionRecipe>
implements IMSDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, ChemicalDemolitionRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_SECOND_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, NOT_ENOUGH_SPACE_SECOND_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final long MAX_CHEMICAL = 10000L;
    public static final int BASE_TICKS_REQUIRED = 100;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGasInput", "getGasInputCapacity", "getGasInputNeeded", "getGasInputFilledPercentage"}, docPlaceholder="gas input tank")
    public IGasTank injectTank;
    public double injectUsage = 1.0;
    private final IOutputHandler firstOutputHandler;
    private final IOutputHandler secondOutputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityChemicalDemolitionMachine> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputGasItem"}, docPlaceholder="gas input item slot")
    GasInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot firstOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot secondOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityChemicalDemolitionMachine(BlockPos pos, BlockState state) {
        super(null, pos, state, TRACKED_ERROR_TYPES, 100);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ENERGY});
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.firstOutputSlot, (IInventorySlot)this.gasInputSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.injectTank).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.INFUSION, (Object)this.injectTank).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.PIGMENT, (Object)this.injectTank).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.SLURRY, (Object)this.injectTank).setEjecting(true);
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.inputSlot), List.of(this.firstOutputSlot, this.secondOutputSlot), (IInventorySlot)this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY}).setCanTankEject(tank -> tank != this.injectTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.injectTank);
        this.firstOutputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.firstOutputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.secondOutputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.secondOutputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_SECOND_OUTPUT_ERROR);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        @NotNull @NotNull BiPredicate canExtract = this.allowExtractingChemical() ? ChemicalTankBuilder.GAS.alwaysTrueBi : ChemicalTankBuilder.GAS.notExternal;
        this.injectTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L, canExtract, (gas, automationType) -> this.containsRecipeBA(this.inputSlot.getStack(), (Chemical)gas), this::containsRecipeB, recipeCacheListener);
        builder.addTank((IChemicalTank)this.injectTank);
        return builder.build();
    }

    protected boolean allowExtractingChemical() {
        return !this.useStatisticalMechanics();
    }

    protected boolean useStatisticalMechanics() {
        return false;
    }

    @Override
    @NotNull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSidePigmentWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideSlurryWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityChemicalDemolitionMachine)this).getDirection(), () -> ((TileEntityChemicalDemolitionMachine)this).getConfig());
        this.gasInputSlot = GasInventorySlot.fillOrConvert((IGasTank)this.injectTank, () -> ((TileEntityChemicalDemolitionMachine)this).m_58904_(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.gasInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, (GasStack)this.injectTank.getStack()), this::containsRecipeA, (IContentsListener)recipeCacheListener, (int)28, (int)36);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.firstOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)116, (int)35);
        builder.addSlot((IInventorySlot)this.firstOutputSlot);
        this.secondOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)132, (int)35);
        builder.addSlot((IInventorySlot)this.secondOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalDemolitionMachine)this).m_58904_(), (IContentsListener)listener, (int)154, (int)62);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    public IMSRecipeTypeProvider<ChemicalDemolitionRecipe, MSInputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDemolitionRecipe>> getMSRecipeType() {
        return MSRecipeType.CHEMICAL_DEMOLITION;
    }

    @Override
    @Nullable
    public ChemicalDemolitionRecipe getRecipe(int cacheIndex) {
        return (ChemicalDemolitionRecipe)this.findFirstRecipe((IInputHandler)this.itemInputHandler, (IInputHandler)this.gasInputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<ChemicalDemolitionRecipe> createNewCachedRecipe(@NotNull ChemicalDemolitionRecipe recipe, int cacheIndex) {
        return new ChemicalDemolitionCachedRecipe(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, () -> StatUtils.inversePoisson((double)this.injectUsage), this.firstOutputHandler, this.secondOutputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityChemicalDemolitionMachine)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityChemicalDemolitionMachine)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.GAS || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
        }
    }

    public MachineEnergyContainer<TileEntityChemicalDemolitionMachine> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

