/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.tile.machine;

import com.fxd927.mekanismelements.api.recipes.RadiationIrradiatingRecipe;
import com.fxd927.mekanismelements.api.recipes.cache.RadiationIrradiatingCachedRecipe;
import com.fxd927.mekanismelements.common.recipe.IMSRecipeTypeProvider;
import com.fxd927.mekanismelements.common.recipe.MSRecipeType;
import com.fxd927.mekanismelements.common.recipe.lookup.IMSDoubleRecipeLookupHandler;
import com.fxd927.mekanismelements.common.recipe.lookup.cache.MSInputRecipeCache;
import com.fxd927.mekanismelements.common.registries.MSBlocks;
import com.fxd927.mekanismelements.common.tile.prefab.MSTileEntityProgressMachine;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRadiationIrradiator
extends MSTileEntityProgressMachine<RadiationIrradiatingRecipe>
implements IMSDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, RadiationIrradiatingRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final long MAX_CHEMICAL = 10000L;
    public static final int BASE_TICKS_REQUIRED = 25;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGasInput", "getGasInputCapacity", "getGasInputNeeded", "getGasInputFilledPercentage"}, docPlaceholder="gas input tank")
    public IGasTank injectTank;
    public MergedChemicalTank outputTank;
    public double injectUsage = 1.0;
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityRadiationIrradiator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputGasItem"}, docPlaceholder="gas input item slot")
    GasInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    MergedChemicalInventorySlot<MergedChemicalTank> outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityRadiationIrradiator(BlockPos pos, BlockState state) {
        super((IBlockProvider)MSBlocks.RADIATION_IRRADIATOR, pos, state, TRACKED_ERROR_TYPES, 25);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY, TransmissionType.ENERGY});
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, this.outputSlot, (IInventorySlot)this.gasInputSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.injectTank, (Object)this.outputTank.getGasTank(), RelativeSide.RIGHT).setEjecting(true);
        this.configComponent.setupOutputConfig(TransmissionType.INFUSION, (Object)this.outputTank.getInfusionTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupOutputConfig(TransmissionType.PIGMENT, (Object)this.outputTank.getPigmentTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupOutputConfig(TransmissionType.SLURRY, (Object)this.outputTank.getSlurryTank(), new RelativeSide[]{RelativeSide.RIGHT});
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY}).setCanTankEject(tank -> tank != this.injectTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.injectTank);
        this.outputHandler = new BoxedChemicalOutputHandler(this.outputTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        IContentsListener saveOnlyListener = () -> ((TileEntityRadiationIrradiator)this).markForSave();
        this.outputTank = MergedChemicalTank.create((IGasTank)((IGasTank)ChemicalTankBuilder.GAS.output(10000L, this.getListener(SubstanceType.GAS, saveOnlyListener))), (IInfusionTank)((IInfusionTank)ChemicalTankBuilder.INFUSION.output(10000L, this.getListener(SubstanceType.INFUSION, saveOnlyListener))), (IPigmentTank)((IPigmentTank)ChemicalTankBuilder.PIGMENT.output(10000L, this.getListener(SubstanceType.PIGMENT, saveOnlyListener))), (ISlurryTank)((ISlurryTank)ChemicalTankBuilder.SLURRY.output(10000L, this.getListener(SubstanceType.SLURRY, saveOnlyListener))));
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        this.injectTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L, ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputTank.getGasTank()), ChemicalTankBuilder.GAS.alwaysTrueBi, this::containsRecipeB, ChemicalAttributeValidator.ALWAYS_ALLOW, recipeCacheListener);
        builder.addTank((IChemicalTank)this.injectTank);
        builder.addTank((IChemicalTank)this.outputTank.getGasTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getInfusionTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSidePigmentWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getPigmentTank());
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideSlurryWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        builder.addTank((IChemicalTank)this.outputTank.getSlurryTank());
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityRadiationIrradiator)this).getDirection(), () -> ((TileEntityRadiationIrradiator)this).getConfig());
        this.gasInputSlot = GasInventorySlot.fillOrConvert((IGasTank)this.injectTank, () -> ((TileEntityRadiationIrradiator)this).m_58904_(), (IContentsListener)listener, (int)7, (int)55);
        builder.addSlot((IInventorySlot)this.gasInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, (GasStack)this.injectTank.getStack()), this::containsRecipeA, (IContentsListener)recipeCacheListener, (int)7, (int)36);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = MergedChemicalInventorySlot.drain((MergedChemicalTank)this.outputTank, (IContentsListener)listener, (int)152, (int)55);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityRadiationIrradiator)this).m_58904_(), (IContentsListener)listener, (int)152, (int)14);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        this.outputSlot.drainChemicalTanks();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    public IMSRecipeTypeProvider<RadiationIrradiatingRecipe, MSInputRecipeCache.ItemChemical<Gas, GasStack, RadiationIrradiatingRecipe>> getMSRecipeType() {
        return MSRecipeType.RADIATION_IRRADIATING;
    }

    @Override
    @Nullable
    public RadiationIrradiatingRecipe getRecipe(int cacheIndex) {
        return (RadiationIrradiatingRecipe)this.findFirstRecipe((IInputHandler)this.itemInputHandler, (IInputHandler)this.gasInputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<RadiationIrradiatingRecipe> createNewCachedRecipe(@NotNull RadiationIrradiatingRecipe recipe, int cacheIndex) {
        return new RadiationIrradiatingCachedRecipe(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, () -> StatUtils.inversePoisson((double)this.injectUsage), this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityRadiationIrradiator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityRadiationIrradiator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.GAS || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
        }
    }

    public MachineEnergyContainer<TileEntityRadiationIrradiator> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    IChemicalTank<?, ?> getOutputTank() {
        MergedChemicalTank.Current current = this.outputTank.getCurrent();
        return this.outputTank.getTankFromCurrent(current == MergedChemicalTank.Current.EMPTY ? MergedChemicalTank.Current.GAS : current);
    }
}

