/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.tile.machine;

import com.fxd927.mekanismelements.common.registries.MSBlocks;
import com.fxd927.mekanismelements.common.registries.MSFluids;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class TileEntitySeawaterPump
extends TileEntityConfigurableMachine
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final FluidStack SEAWATER_STACK = new FluidStack(MSFluids.SEAWATER.getFluid(), 200);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="buffer tank")
    public BasicFluidTank fluidTank;
    public int ticksRequired = 19;
    public int operatingTicks;
    private MachineEnergyContainer<TileEntitySeawaterPump> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="")
    private EnergyInventorySlot energySlot;

    public TileEntitySeawaterPump(BlockPos pos, BlockState state) {
        super(MSBlocks.SEAWATER_PUMP, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE, (Object)((Object)this)));
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIG_CARD, (Object)((Object)this)));
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig(List.of(this.inputSlot), List.of(this.outputSlot), (IInventorySlot)this.energySlot, true);
        this.configComponent.setupOutputConfig(TransmissionType.FLUID, (Object)this.fluidTank, new RelativeSide[]{RelativeSide.TOP});
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this));
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.FLUID}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this));
    }

    @Nonnull
    public IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntitySeawaterPump)this).getDirection());
        this.fluidTank = BasicFluidTank.output((int)10000, (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.fluidTank, new RelativeSide[]{RelativeSide.TOP});
        return builder.build();
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntitySeawaterPump)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntitySeawaterPump)this).getDirection());
        this.inputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)28, (int)20);
        builder.addSlot((IInventorySlot)this.inputSlot, new RelativeSide[]{RelativeSide.TOP});
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)28, (int)51);
        builder.addSlot((IInventorySlot)this.outputSlot, new RelativeSide[]{RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntitySeawaterPump)this).m_58904_(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.m_58904_().m_204166_(this.m_58899_()).m_203656_(BiomeTags.f_207603_)) {
            BlockPos belowPos = this.m_58899_().m_7495_();
            BlockState belowState = this.m_58904_().m_8055_(belowPos);
            if (belowState.m_60819_().m_76170_() && belowState.m_60819_().m_76152_() == Fluids.f_76193_) {
                FloatingLong energyPerTick;
                this.energySlot.fillContainerOrConvert();
                this.inputSlot.drainTank((IInventorySlot)this.outputSlot);
                if (MekanismUtils.canFunction((TileEntityMekanism)this) && SEAWATER_STACK.getAmount() <= this.fluidTank.getNeeded() && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                    ++this.operatingTicks;
                    if (this.operatingTicks >= this.ticksRequired) {
                        this.operatingTicks = 0;
                        this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        this.fluidTank.insert(SEAWATER_STACK, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                }
                if (!this.fluidTank.isEmpty()) {
                    FluidUtils.emit(Collections.singleton(Direction.UP), (IExtendedFluidTank)this.fluidTank, (BlockEntity)this, (int)(256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED))));
                }
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("progress", this.operatingTicks);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
    }

    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean canPulse() {
        return true;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)19);
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fluidTank.getFluidAmount(), (long)this.fluidTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.FLUID;
    }

    public List<Component> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public MachineEnergyContainer<TileEntitySeawaterPump> getEnergyContainer() {
        return this.energyContainer;
    }
}

