/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets;

import com.github.x3r.mekanism_turrets.MekanismTurretsConfig;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import com.github.x3r.mekanism_turrets.common.entity.LaserEntity;
import com.github.x3r.mekanism_turrets.common.packet.MekanismTurretsPacketHandler;
import com.github.x3r.mekanism_turrets.common.registry.BlockEntityTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.BlockRegistry;
import com.github.x3r.mekanism_turrets.common.registry.ContainerTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.EntityRegistry;
import com.github.x3r.mekanism_turrets.common.registry.ItemRegistry;
import com.github.x3r.mekanism_turrets.common.registry.SoundRegistry;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod(value="mekanism_turrets")
public class MekanismTurrets {
    public static final String MOD_ID = "mekanism_turrets";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MekanismTurrets() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        BlockRegistry.BLOCKS.register(modEventBus);
        BlockEntityTypeRegistry.BLOCK_ENTITY_TYPES.register(modEventBus);
        ContainerTypeRegistry.CONTAINER_TYPES.register(modEventBus);
        EntityRegistry.ENTITY_TYPES.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.ModItemTab.CREATIVE_MODE_TABS.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MekanismTurretsConfig.SPEC);
        modEventBus.addListener(this::loadConfig);
        MekanismTurretsPacketHandler.registerPackets();
        forgeBus.addListener(LaserEntity::enterChunk);
        this.registerDataTickets();
    }

    @SubscribeEvent
    public void loadConfig(ModConfigEvent.Loading event) {
        LaserTurretTier.BASIC.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.basicLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.basicLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.basicLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.basicLaserTurretRange);
        LaserTurretTier.ADVANCED.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.advancedLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.advancedLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.advancedLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.advancedLaserTurretRange);
        LaserTurretTier.ELITE.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.eliteLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.eliteLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.eliteLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.eliteLaserTurretRange);
        LaserTurretTier.ULTIMATE.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.ultimateLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.ultimateLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.ultimateLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.ultimateLaserTurretRange);
    }

    private void registerDataTickets() {
        LaserTurretBlockEntity.HAS_TARGET = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofBoolean((ResourceLocation)new ResourceLocation(MOD_ID, "has_target")));
        LaserTurretBlockEntity.TARGET_POS_X = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)new ResourceLocation(MOD_ID, "target_pos_x")));
        LaserTurretBlockEntity.TARGET_POS_Y = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)new ResourceLocation(MOD_ID, "target_pos_y")));
        LaserTurretBlockEntity.TARGET_POS_Z = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)new ResourceLocation(MOD_ID, "target_pos_z")));
    }
}

