/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block_entity;

import com.github.x3r.mekanism_turrets.MekanismTurretsConfig;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretUpgradeData;
import com.github.x3r.mekanism_turrets.common.entity.LaserEntity;
import com.github.x3r.mekanism_turrets.common.registry.SoundRegistry;
import com.github.x3r.mekanism_turrets.common.scheduler.Scheduler;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserTurretBlockEntity
extends TileEntityMekanism
implements GeoBlockEntity {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    public static SerializableDataTicket<Boolean> HAS_TARGET;
    public static SerializableDataTicket<Double> TARGET_POS_X;
    public static SerializableDataTicket<Double> TARGET_POS_Y;
    public static SerializableDataTicket<Double> TARGET_POS_Z;
    private static final RawAnimation SHOOT_ANIMATION;
    private final AABB targetBox = AABB.m_165882_((Vec3)this.m_58899_().m_252807_(), (double)(this.getTier().getRange() * 2.0), (double)(this.getTier().getRange() * 2.0), (double)(this.getTier().getRange() * 2.0));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LaserTurretTier tier;
    private MachineEnergyContainer<LaserTurretBlockEntity> energyContainer;
    private boolean targetsHostile = true;
    private boolean targetsPassive = false;
    private boolean targetsPlayers = false;
    private boolean targetsTrusted = true;
    @Nullable
    private LivingEntity target;
    public float xRot0 = 0.0f;
    public float yRot0 = 0.0f;
    private int coolDown = 0;
    private int idleTicks = 0;

    public LaserTurretBlockEntity(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    public void blockRemoved() {
        Vec3 pos = this.m_58899_().m_252807_();
        for (Upgrade upgrade : this.upgradeComponent.getInstalledTypes()) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, UpgradeUtils.getStack((Upgrade)upgrade, (int)this.upgradeComponent.getUpgrades(upgrade))));
        }
        super.blockRemoved();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((LaserTurretBlockEntity)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    public MachineEnergyContainer<LaserTurretBlockEntity> getEnergyContainer() {
        return this.energyContainer;
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((LaserTurretBlockEntity)this).getDirection());
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((LaserTurretBlockEntity)this).m_58904_(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    public LaserTurretTier getTier() {
        return this.tier;
    }

    public boolean targetsHostile() {
        return this.targetsHostile;
    }

    public void setTargetsHostile(boolean targetsHostile) {
        this.targetsHostile = targetsHostile;
    }

    public boolean targetsPassive() {
        return this.targetsPassive;
    }

    public void setTargetsPassive(boolean targetsPassive) {
        this.targetsPassive = targetsPassive;
    }

    public boolean targetsPlayers() {
        return this.targetsPlayers;
    }

    public void setTargetsPlayers(boolean targetsPlayers) {
        this.targetsPlayers = targetsPlayers;
    }

    public boolean targetsTrusted() {
        return this.targetsTrusted;
    }

    public void setTargetsTrusted(boolean targetsTrusted) {
        this.targetsTrusted = targetsTrusted;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.tryInvalidateTarget();
        this.tryFindTarget();
        this.energyContainer.setEnergyPerTick(FloatingLong.create((long)this.laserShotEnergy()));
        if (this.target != null) {
            Vec3 targetPos = LaserTurretBlockEntity.getShootLocation(this.target);
            this.setAnimData(TARGET_POS_X, targetPos.f_82479_);
            this.setAnimData(TARGET_POS_Y, targetPos.f_82480_);
            this.setAnimData(TARGET_POS_Z, targetPos.f_82481_);
            this.setAnimData(HAS_TARGET, this.target != null);
            if (this.coolDown == 0) {
                this.coolDown = Math.max(2, this.tier.getCooldown() - 2 * this.upgradeComponent.getUpgrades(Upgrade.SPEED));
                if (this.energyContainer.getEnergy().greaterOrEqual(FloatingLong.create((long)this.laserShotEnergy()))) {
                    this.shootLaser();
                    if (this.tier.equals((Object)LaserTurretTier.ULTIMATE)) {
                        Scheduler.schedule(this::shootLaser, this.coolDown / 2);
                    }
                }
            } else {
                --this.coolDown;
            }
        }
    }

    private static Vec3 getShootLocation(LivingEntity entity) {
        Vec3 targetPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        double laserSpeed = 2.25;
        for (int i = 1; i < 21; ++i) {
            Vec3 deltaMovement = entity.m_20184_().m_82542_(0.95, 0.0, 0.95);
            Vec3 nextPos = targetPos.m_82549_(deltaMovement.m_82490_((double)(i - 1)));
            if (!(nextPos.m_82553_() <= laserSpeed * (double)i) && i != 20) continue;
            return new Vec3(nextPos.f_82479_, nextPos.f_82480_ + (double)entity.m_20206_() * 0.75, nextPos.f_82481_);
        }
        return targetPos;
    }

    private void shootLaser() {
        if (this.target != null) {
            int mufflerCount = this.getComponent().getUpgrades(Upgrade.MUFFLING);
            float volume = 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.TURRET_SHOOT.get(), SoundSource.BLOCKS, volume, 1.0f);
            this.triggerAnim("controller", "shoot");
            Vec3 center = this.m_58899_().m_252807_();
            Vec3 targetPos = LaserTurretBlockEntity.getShootLocation(this.target);
            LaserEntity laser = new LaserEntity(this.f_58857_, center.m_82520_(0.0, -0.15, 0.0), this.tier.getDamage());
            laser.m_20256_(center.m_82505_(targetPos).m_82541_().m_82490_(2.25));
            this.f_58857_.m_7967_((Entity)laser);
            this.energyContainer.extract(FloatingLong.create((long)this.laserShotEnergy()), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    private int laserShotEnergy() {
        return 1000 * (this.tier.ordinal() + 1) * Mth.m_144944_((int)(this.upgradeComponent.getUpgrades(Upgrade.SPEED) + 1));
    }

    public void tryInvalidateTarget() {
        if (!this.isValidTarget(this.target)) {
            this.setAnimData(HAS_TARGET, false);
            this.target = null;
        }
    }

    private void tryFindTarget() {
        if (this.idleTicks-- > 0) {
            return;
        }
        if (this.target == null && (this.f_58857_.m_46467_() + (long)((Object)((Object)this)).hashCode()) % 3L == 0L) {
            Optional optional = this.f_58857_.m_6443_(LivingEntity.class, this.targetBox, this::isValidTarget).stream().min((o1, o2) -> Double.compare(o1.m_20238_(this.m_58899_().m_252807_()), o2.m_20238_(this.m_58899_().m_252807_())));
            if (optional.isPresent()) {
                this.target = (LivingEntity)optional.get();
                this.setAnimData(HAS_TARGET, true);
            } else {
                this.idleTicks = 80;
            }
        }
    }

    private boolean isValidTarget(LivingEntity e) {
        if (e == null) {
            return false;
        }
        if (!e.m_142066_()) {
            return false;
        }
        if (e.m_20238_(this.m_58899_().m_252807_()) > this.getTier().getRange() * this.getTier().getRange()) {
            return false;
        }
        if (MekanismTurretsConfig.blacklistedEntities == null) {
            return false;
        }
        if (((List)MekanismTurretsConfig.blacklistedEntities.get()).stream().map(s -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(s))).anyMatch(entityType -> e.m_6095_().equals(entityType))) {
            return false;
        }
        if (!this.turretFlagsAllowTargeting(e)) {
            return false;
        }
        return this.canSeeTarget(e);
    }

    private boolean turretFlagsAllowTargeting(LivingEntity e) {
        Player player;
        MobCategory category = e.m_6095_().m_20674_();
        if (this.targetsHostile && !category.m_21609_()) {
            return true;
        }
        if (this.targetsPassive && category.m_21609_() && !category.equals((Object)MobCategory.MISC)) {
            return true;
        }
        UUID owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)this);
        if (this.targetsPlayers && e instanceof Player && !(player = (Player)e).m_20148_().equals(owner)) {
            if (this.targetsTrusted) {
                return true;
            }
            SecurityFrequency frequency = (SecurityFrequency)FrequencyType.SECURITY.getManager(null).getFrequency((Object)owner);
            if (frequency == null) {
                return true;
            }
            if (!frequency.getTrustedUUIDs().contains(player.m_20148_())) {
                return true;
            }
        }
        return false;
    }

    private boolean canSeeTarget(LivingEntity e) {
        Vec3 center = this.m_58899_().m_252807_();
        Vec3 targetPos = e.m_20182_().m_82520_(0.0, (double)e.m_20206_() * 0.75, 0.0);
        Vec3 lookVec = center.m_82505_(targetPos).m_82541_().m_82490_(0.75);
        ClipContext ctx = new ClipContext(center.m_82549_(lookVec), targetPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null);
        return this.f_58857_.m_45547_(ctx).m_6662_().equals((Object)HitResult.Type.MISS);
    }

    public void parseUpgradeData(@NotNull IUpgradeData data) {
        if (data instanceof LaserTurretUpgradeData) {
            LaserTurretUpgradeData upgradeData = (LaserTurretUpgradeData)data;
            this.targetsHostile = upgradeData.targetsHostile();
            this.targetsPassive = upgradeData.targetsPassive();
            this.targetsPlayers = upgradeData.targetsPlayers();
            this.targetsTrusted = upgradeData.targetsTrusted();
            for (ITileComponent component : this.getComponents()) {
                component.read(upgradeData.components());
            }
        } else {
            super.parseUpgradeData(data);
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new LaserTurretUpgradeData(this.targetsHostile, this.targetsPassive, this.targetsPlayers, this.targetsTrusted, this.getComponents());
    }

    public void onLoad() {
        super.onLoad();
        this.markUpdated();
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("targetsHostile", this.targetsHostile);
        tag.m_128379_("targetsPassive", this.targetsPassive);
        tag.m_128379_("targetsPlayers", this.targetsPlayers);
        tag.m_128379_("targetsTrusted", this.targetsTrusted);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsHostile", value -> {
            this.targetsHostile = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPassive", value -> {
            this.targetsPassive = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPlayers", value -> {
            this.targetsPlayers = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsTrusted", value -> {
            this.targetsTrusted = value;
        });
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag tag = super.getReducedUpdateTag();
        tag.m_128379_("targetsHostile", this.targetsHostile);
        tag.m_128379_("targetsPassive", this.targetsPassive);
        tag.m_128379_("targetsPlayers", this.targetsPlayers);
        tag.m_128379_("targetsTrusted", this.targetsTrusted);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsHostile", value -> {
            this.targetsHostile = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPassive", value -> {
            this.targetsPassive = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPlayers", value -> {
            this.targetsPlayers = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsTrusted", value -> {
            this.targetsTrusted = value;
        });
    }

    public void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        if (!this.f_58857_.m_5776_()) {
            this.sendUpdatePacket();
        }
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = (LaserTurretTier)Attribute.getTier((Block)this.getBlockType(), LaserTurretTier.class);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE).triggerableAnim("shoot", SHOOT_ANIMATION)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static {
        SHOOT_ANIMATION = RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE);
    }
}

