/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.compat.jei.category;

import java.awt.Rectangle;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.herbalbrews.core.recipe.TeaKettleRecipe;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public class TeaKettleCategory
implements IRecipeCategory<TeaKettleRecipe> {
    public static final RecipeType<TeaKettleRecipe> TEA_KETTLE_TYPE = RecipeType.create((String)"herbalbrews", (String)"tea_kettle_brewing", TeaKettleRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private static final Vector2i ARROW_POS = new Vector2i(54, 22);
    private static final int ARROW_U = 176;
    private static final int ARROW_V = 14;
    private static final int ARROW_WIDTH = 24;
    private static final int ARROW_HEIGHT = 17;
    private static final int MAX_TIME = 200;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final Component title;
    private final ResourceLocation texture = new ResourceLocation("herbalbrews", "textures/gui/tea_kettle.png");

    public TeaKettleCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(this.texture, 10, 10, 160, 70);
        this.arrow = helper.drawableBuilder(this.texture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        ItemStack kettleStack = new ItemStack((ItemLike)ObjectRegistry.TEA_KETTLE.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)kettleStack);
        this.burnIcon = helper.createDrawable(this.texture, 176, 0, 14, 14);
        this.title = ((Block)ObjectRegistry.TEA_KETTLE.get()).m_49954_();
    }

    @NotNull
    public RecipeType<TeaKettleRecipe> getRecipeType() {
        return TEA_KETTLE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TeaKettleRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = Math.min(ingredients.size(), 4);
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 12).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        ItemStack waterBottle = new ItemStack((ItemLike)Items.f_42589_);
        waterBottle.m_41784_().m_128359_("Potion", "minecraft:water");
        builder.addSlot(RecipeIngredientRole.INPUT, 108, 33).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42447_), waterBottle}));
        int idx = 0;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2 && idx < s; ++idx, ++col) {
                Ingredient ingredient = (Ingredient)ingredients.get(idx);
                Ingredient filteredIngredient = this.filterOutTag(ingredient);
                if (filteredIngredient.m_43947_()) continue;
                int xPos = 13 + col * 18;
                int yPos = 12 + row * 18;
                builder.addSlot(RecipeIngredientRole.INPUT, xPos - 10, yPos - 10).addIngredients(filteredIngredient);
            }
        }
        if (this.containsTagIngredient(ingredients)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 42).addIngredients(Ingredient.m_204132_((TagKey)ItemTags.m_203854_((String)TagsRegistry.CONTAINER_ITEMS.f_203868_().toString())));
        }
        if (this.containsTagIngredient(ingredients)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 85, 48).addIngredients(Ingredient.m_204132_((TagKey)ItemTags.m_203854_((String)TagsRegistry.HEAT_ITEMS.f_203868_().toString())));
        }
    }

    private Ingredient filterOutTag(Ingredient ingredient) {
        ArrayList<ItemStack> filteredStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredient.m_43908_()) {
            if (stack.m_204117_(TagsRegistry.CONTAINER_ITEMS)) continue;
            filteredStacks.add(stack);
        }
        return filteredStacks.isEmpty() ? Ingredient.f_43901_ : Ingredient.m_43927_((ItemStack[])filteredStacks.toArray(new ItemStack[0]));
    }

    private boolean containsTagIngredient(NonNullList<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!stack.m_204117_(TagsRegistry.CONTAINER_ITEMS)) continue;
                return true;
            }
        }
        return false;
    }

    public void draw(TeaKettleRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, ARROW_POS.x() - 10, ARROW_POS.y() - 10);
        this.burnIcon.draw(guiGraphics, 142, 52);
        int requiredWater = recipe.getRequiredWater();
        int fluidFillHeight = Math.min(requiredWater * 43 / 100, 43);
        guiGraphics.m_280218_(this.texture, 131, 6 + (43 - fluidFillHeight), 183, 31 + (43 - fluidFillHeight), 8, fluidFillHeight);
        int requiredHeat = recipe.getRequiredHeat();
        int heatFillHeight = Math.min(requiredHeat * 43 / 100, 43);
        guiGraphics.m_280218_(this.texture, 146, 6 + (43 - heatFillHeight), 176, 31 + (43 - heatFillHeight), 5, heatFillHeight);
        Rectangle requiredFluidPos = new Rectangle(131, 6, 8, 43);
        Rectangle requiredHeatPos = new Rectangle(146, 6, 5, 43);
    }
}

