/*
 * Decompiled with CFR 0.152.
 */
package io.github.steelwoolmc.mixintransmog;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.INameMappingService;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class MixinModlauncherRemapper
implements IRemapper {
    private final BiFunction<INameMappingService.Domain, String, String> mapping = (BiFunction)Optional.ofNullable(Launcher.INSTANCE).map(Launcher::environment).flatMap(env -> env.findNameMapping("srg")).orElseThrow();

    public String mapMethodName(String owner, String name, String desc) {
        String mapped = this.mapping.apply(INameMappingService.Domain.METHOD, name);
        if (mapped != null && mapped.equals(name) && name.startsWith("f_")) {
            return this.mapping.apply(INameMappingService.Domain.FIELD, name);
        }
        return mapped;
    }

    public String mapFieldName(String owner, String name, String desc) {
        return this.mapping.apply(INameMappingService.Domain.FIELD, name);
    }

    public String map(String typeName) {
        return this.mapping.apply(INameMappingService.Domain.CLASS, typeName);
    }

    public String unmap(String typeName) {
        return typeName;
    }

    public String mapDesc(String desc) {
        if (desc.startsWith("(")) {
            StringBuilder stringBuilder = new StringBuilder("(");
            Arrays.stream(Type.getArgumentTypes((String)desc)).map(this::mapType).forEach(stringBuilder::append);
            Type returnType = Type.getReturnType((String)desc);
            stringBuilder.append(")").append(this.mapType(returnType));
            return stringBuilder.toString();
        }
        if (desc.startsWith("L")) {
            String cls = desc.substring(1, desc.length() - 1);
            return "L" + this.map(cls) + ";";
        }
        return desc;
    }

    public String unmapDesc(String desc) {
        return desc;
    }

    private Type mapType(Type type) {
        return type.getSort() == 10 ? Type.getObjectType((String)this.map(type.getClassName()).replace('.', '/')) : type;
    }
}

